/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ConnectorOAuthRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HoneycodeConnectorProfileCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HoneycodeConnectorProfileCredentials> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessToken").getter(HoneycodeConnectorProfileCredentials.getter(HoneycodeConnectorProfileCredentials::accessToken)).setter(HoneycodeConnectorProfileCredentials.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()}).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("refreshToken").getter(HoneycodeConnectorProfileCredentials.getter(HoneycodeConnectorProfileCredentials::refreshToken)).setter(HoneycodeConnectorProfileCredentials.setter(Builder::refreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()}).build();
    private static final SdkField<ConnectorOAuthRequest> O_AUTH_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuthRequest").getter(HoneycodeConnectorProfileCredentials.getter(HoneycodeConnectorProfileCredentials::oAuthRequest)).setter(HoneycodeConnectorProfileCredentials.setter(Builder::oAuthRequest)).constructor(ConnectorOAuthRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthRequest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, REFRESH_TOKEN_FIELD, O_AUTH_REQUEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HoneycodeConnectorProfileCredentials.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final String refreshToken;
    private final ConnectorOAuthRequest oAuthRequest;

    private HoneycodeConnectorProfileCredentials(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.oAuthRequest = builder.oAuthRequest;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public final ConnectorOAuthRequest oAuthRequest() {
        return this.oAuthRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HoneycodeConnectorProfileCredentials)) {
            return false;
        }
        HoneycodeConnectorProfileCredentials other = (HoneycodeConnectorProfileCredentials)obj;
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.oAuthRequest(), other.oAuthRequest());
    }

    public final String toString() {
        return ToString.builder((String)"HoneycodeConnectorProfileCredentials").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("RefreshToken", (Object)this.refreshToken()).add("OAuthRequest", (Object)this.oAuthRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "refreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "oAuthRequest": {
                return Optional.ofNullable(clazz.cast(this.oAuthRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        map.put("refreshToken", REFRESH_TOKEN_FIELD);
        map.put("oAuthRequest", O_AUTH_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HoneycodeConnectorProfileCredentials, T> g) {
        return obj -> g.apply((HoneycodeConnectorProfileCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessToken;
        private String refreshToken;
        private ConnectorOAuthRequest oAuthRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(HoneycodeConnectorProfileCredentials model) {
            this.accessToken(model.accessToken);
            this.refreshToken(model.refreshToken);
            this.oAuthRequest(model.oAuthRequest);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final ConnectorOAuthRequest.Builder getOAuthRequest() {
            return this.oAuthRequest != null ? this.oAuthRequest.toBuilder() : null;
        }

        public final void setOAuthRequest(ConnectorOAuthRequest.BuilderImpl oAuthRequest) {
            this.oAuthRequest = oAuthRequest != null ? oAuthRequest.build() : null;
        }

        @Override
        public final Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest) {
            this.oAuthRequest = oAuthRequest;
            return this;
        }

        public HoneycodeConnectorProfileCredentials build() {
            return new HoneycodeConnectorProfileCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HoneycodeConnectorProfileCredentials> {
        public Builder accessToken(String var1);

        public Builder refreshToken(String var1);

        public Builder oAuthRequest(ConnectorOAuthRequest var1);

        default public Builder oAuthRequest(Consumer<ConnectorOAuthRequest.Builder> oAuthRequest) {
            return this.oAuthRequest((ConnectorOAuthRequest)((ConnectorOAuthRequest.Builder)ConnectorOAuthRequest.builder().applyMutation(oAuthRequest)).build());
        }
    }
}

