/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AggregationConfig;
import software.amazon.awssdk.services.appflow.model.FileType;
import software.amazon.awssdk.services.appflow.model.PrefixConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpsolverS3OutputFormatConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpsolverS3OutputFormatConfig> {
    private static final SdkField<String> FILE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileType").getter(UpsolverS3OutputFormatConfig.getter(UpsolverS3OutputFormatConfig::fileTypeAsString)).setter(UpsolverS3OutputFormatConfig.setter(Builder::fileType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileType").build()}).build();
    private static final SdkField<PrefixConfig> PREFIX_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("prefixConfig").getter(UpsolverS3OutputFormatConfig.getter(UpsolverS3OutputFormatConfig::prefixConfig)).setter(UpsolverS3OutputFormatConfig.setter(Builder::prefixConfig)).constructor(PrefixConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefixConfig").build()}).build();
    private static final SdkField<AggregationConfig> AGGREGATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregationConfig").getter(UpsolverS3OutputFormatConfig.getter(UpsolverS3OutputFormatConfig::aggregationConfig)).setter(UpsolverS3OutputFormatConfig.setter(Builder::aggregationConfig)).constructor(AggregationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_TYPE_FIELD, PREFIX_CONFIG_FIELD, AGGREGATION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpsolverS3OutputFormatConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fileType;
    private final PrefixConfig prefixConfig;
    private final AggregationConfig aggregationConfig;

    private UpsolverS3OutputFormatConfig(BuilderImpl builder) {
        this.fileType = builder.fileType;
        this.prefixConfig = builder.prefixConfig;
        this.aggregationConfig = builder.aggregationConfig;
    }

    public final FileType fileType() {
        return FileType.fromValue(this.fileType);
    }

    public final String fileTypeAsString() {
        return this.fileType;
    }

    public final PrefixConfig prefixConfig() {
        return this.prefixConfig;
    }

    public final AggregationConfig aggregationConfig() {
        return this.aggregationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpsolverS3OutputFormatConfig)) {
            return false;
        }
        UpsolverS3OutputFormatConfig other = (UpsolverS3OutputFormatConfig)obj;
        return Objects.equals(this.fileTypeAsString(), other.fileTypeAsString()) && Objects.equals(this.prefixConfig(), other.prefixConfig()) && Objects.equals(this.aggregationConfig(), other.aggregationConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpsolverS3OutputFormatConfig").add("FileType", (Object)this.fileTypeAsString()).add("PrefixConfig", (Object)this.prefixConfig()).add("AggregationConfig", (Object)this.aggregationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileType": {
                return Optional.ofNullable(clazz.cast(this.fileTypeAsString()));
            }
            case "prefixConfig": {
                return Optional.ofNullable(clazz.cast(this.prefixConfig()));
            }
            case "aggregationConfig": {
                return Optional.ofNullable(clazz.cast(this.aggregationConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileType", FILE_TYPE_FIELD);
        map.put("prefixConfig", PREFIX_CONFIG_FIELD);
        map.put("aggregationConfig", AGGREGATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpsolverS3OutputFormatConfig, T> g) {
        return obj -> g.apply((UpsolverS3OutputFormatConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileType;
        private PrefixConfig prefixConfig;
        private AggregationConfig aggregationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpsolverS3OutputFormatConfig model) {
            this.fileType(model.fileType);
            this.prefixConfig(model.prefixConfig);
            this.aggregationConfig(model.aggregationConfig);
        }

        public final String getFileType() {
            return this.fileType;
        }

        public final void setFileType(String fileType) {
            this.fileType = fileType;
        }

        @Override
        public final Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        @Override
        public final Builder fileType(FileType fileType) {
            this.fileType(fileType == null ? null : fileType.toString());
            return this;
        }

        public final PrefixConfig.Builder getPrefixConfig() {
            return this.prefixConfig != null ? this.prefixConfig.toBuilder() : null;
        }

        public final void setPrefixConfig(PrefixConfig.BuilderImpl prefixConfig) {
            this.prefixConfig = prefixConfig != null ? prefixConfig.build() : null;
        }

        @Override
        public final Builder prefixConfig(PrefixConfig prefixConfig) {
            this.prefixConfig = prefixConfig;
            return this;
        }

        public final AggregationConfig.Builder getAggregationConfig() {
            return this.aggregationConfig != null ? this.aggregationConfig.toBuilder() : null;
        }

        public final void setAggregationConfig(AggregationConfig.BuilderImpl aggregationConfig) {
            this.aggregationConfig = aggregationConfig != null ? aggregationConfig.build() : null;
        }

        @Override
        public final Builder aggregationConfig(AggregationConfig aggregationConfig) {
            this.aggregationConfig = aggregationConfig;
            return this;
        }

        public UpsolverS3OutputFormatConfig build() {
            return new UpsolverS3OutputFormatConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpsolverS3OutputFormatConfig> {
        public Builder fileType(String var1);

        public Builder fileType(FileType var1);

        public Builder prefixConfig(PrefixConfig var1);

        default public Builder prefixConfig(Consumer<PrefixConfig.Builder> prefixConfig) {
            return this.prefixConfig((PrefixConfig)((PrefixConfig.Builder)PrefixConfig.builder().applyMutation(prefixConfig)).build());
        }

        public Builder aggregationConfig(AggregationConfig var1);

        default public Builder aggregationConfig(Consumer<AggregationConfig.Builder> aggregationConfig) {
            return this.aggregationConfig((AggregationConfig)((AggregationConfig.Builder)AggregationConfig.builder().applyMutation(aggregationConfig)).build());
        }
    }
}

