/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnregisterConnectorRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, UnregisterConnectorRequest> {
    private static final SdkField<String> CONNECTOR_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorLabel").getter(UnregisterConnectorRequest.getter(UnregisterConnectorRequest::connectorLabel)).setter(UnregisterConnectorRequest.setter(Builder::connectorLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorLabel").build()}).build();
    private static final SdkField<Boolean> FORCE_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("forceDelete").getter(UnregisterConnectorRequest.getter(UnregisterConnectorRequest::forceDelete)).setter(UnregisterConnectorRequest.setter(Builder::forceDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceDelete").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_LABEL_FIELD, FORCE_DELETE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UnregisterConnectorRequest.memberNameToFieldInitializer();
    private final String connectorLabel;
    private final Boolean forceDelete;

    private UnregisterConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.connectorLabel = builder.connectorLabel;
        this.forceDelete = builder.forceDelete;
    }

    public final String connectorLabel() {
        return this.connectorLabel;
    }

    public final Boolean forceDelete() {
        return this.forceDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceDelete());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnregisterConnectorRequest)) {
            return false;
        }
        UnregisterConnectorRequest other = (UnregisterConnectorRequest)((Object)obj);
        return Objects.equals(this.connectorLabel(), other.connectorLabel()) && Objects.equals(this.forceDelete(), other.forceDelete());
    }

    public final String toString() {
        return ToString.builder((String)"UnregisterConnectorRequest").add("ConnectorLabel", (Object)this.connectorLabel()).add("ForceDelete", (Object)this.forceDelete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorLabel": {
                return Optional.ofNullable(clazz.cast(this.connectorLabel()));
            }
            case "forceDelete": {
                return Optional.ofNullable(clazz.cast(this.forceDelete()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectorLabel", CONNECTOR_LABEL_FIELD);
        map.put("forceDelete", FORCE_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnregisterConnectorRequest, T> g) {
        return obj -> g.apply((UnregisterConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private String connectorLabel;
        private Boolean forceDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(UnregisterConnectorRequest model) {
            super(model);
            this.connectorLabel(model.connectorLabel);
            this.forceDelete(model.forceDelete);
        }

        public final String getConnectorLabel() {
            return this.connectorLabel;
        }

        public final void setConnectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
        }

        @Override
        public final Builder connectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        public final Boolean getForceDelete() {
            return this.forceDelete;
        }

        public final void setForceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
        }

        @Override
        public final Builder forceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UnregisterConnectorRequest build() {
            return new UnregisterConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UnregisterConnectorRequest> {
        public Builder connectorLabel(String var1);

        public Builder forceDelete(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

