/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectorEntityRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, DescribeConnectorEntityRequest> {
    private static final SdkField<String> CONNECTOR_ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorEntityName").getter(DescribeConnectorEntityRequest.getter(DescribeConnectorEntityRequest::connectorEntityName)).setter(DescribeConnectorEntityRequest.setter(Builder::connectorEntityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorEntityName").build()}).build();
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorType").getter(DescribeConnectorEntityRequest.getter(DescribeConnectorEntityRequest::connectorTypeAsString)).setter(DescribeConnectorEntityRequest.setter(Builder::connectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()}).build();
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorProfileName").getter(DescribeConnectorEntityRequest.getter(DescribeConnectorEntityRequest::connectorProfileName)).setter(DescribeConnectorEntityRequest.setter(Builder::connectorProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build()}).build();
    private static final SdkField<String> API_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiVersion").getter(DescribeConnectorEntityRequest.getter(DescribeConnectorEntityRequest::apiVersion)).setter(DescribeConnectorEntityRequest.setter(Builder::apiVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ENTITY_NAME_FIELD, CONNECTOR_TYPE_FIELD, CONNECTOR_PROFILE_NAME_FIELD, API_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConnectorEntityRequest.memberNameToFieldInitializer();
    private final String connectorEntityName;
    private final String connectorType;
    private final String connectorProfileName;
    private final String apiVersion;

    private DescribeConnectorEntityRequest(BuilderImpl builder) {
        super(builder);
        this.connectorEntityName = builder.connectorEntityName;
        this.connectorType = builder.connectorType;
        this.connectorProfileName = builder.connectorProfileName;
        this.apiVersion = builder.apiVersion;
    }

    public final String connectorEntityName() {
        return this.connectorEntityName;
    }

    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(this.connectorType);
    }

    public final String connectorTypeAsString() {
        return this.connectorType;
    }

    public final String connectorProfileName() {
        return this.connectorProfileName;
    }

    public final String apiVersion() {
        return this.apiVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorEntityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorEntityRequest)) {
            return false;
        }
        DescribeConnectorEntityRequest other = (DescribeConnectorEntityRequest)((Object)obj);
        return Objects.equals(this.connectorEntityName(), other.connectorEntityName()) && Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.connectorProfileName(), other.connectorProfileName()) && Objects.equals(this.apiVersion(), other.apiVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectorEntityRequest").add("ConnectorEntityName", (Object)this.connectorEntityName()).add("ConnectorType", (Object)this.connectorTypeAsString()).add("ConnectorProfileName", (Object)this.connectorProfileName()).add("ApiVersion", (Object)this.apiVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorEntityName": {
                return Optional.ofNullable(clazz.cast(this.connectorEntityName()));
            }
            case "connectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "connectorProfileName": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileName()));
            }
            case "apiVersion": {
                return Optional.ofNullable(clazz.cast(this.apiVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("connectorEntityName", CONNECTOR_ENTITY_NAME_FIELD);
        map.put("connectorType", CONNECTOR_TYPE_FIELD);
        map.put("connectorProfileName", CONNECTOR_PROFILE_NAME_FIELD);
        map.put("apiVersion", API_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorEntityRequest, T> g) {
        return obj -> g.apply((DescribeConnectorEntityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private String connectorEntityName;
        private String connectorType;
        private String connectorProfileName;
        private String apiVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorEntityRequest model) {
            super(model);
            this.connectorEntityName(model.connectorEntityName);
            this.connectorType(model.connectorType);
            this.connectorProfileName(model.connectorProfileName);
            this.apiVersion(model.apiVersion);
        }

        public final String getConnectorEntityName() {
            return this.connectorEntityName;
        }

        public final void setConnectorEntityName(String connectorEntityName) {
            this.connectorEntityName = connectorEntityName;
        }

        @Override
        public final Builder connectorEntityName(String connectorEntityName) {
            this.connectorEntityName = connectorEntityName;
            return this;
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorProfileName() {
            return this.connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final String getApiVersion() {
            return this.apiVersion;
        }

        public final void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        @Override
        public final Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConnectorEntityRequest build() {
            return new DescribeConnectorEntityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectorEntityRequest> {
        public Builder connectorEntityName(String var1);

        public Builder connectorType(String var1);

        public Builder connectorType(ConnectorType var1);

        public Builder connectorProfileName(String var1);

        public Builder apiVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

