/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.PathPrefix;
import software.amazon.awssdk.services.appflow.model.PathPrefixHierarchyCopier;
import software.amazon.awssdk.services.appflow.model.PrefixFormat;
import software.amazon.awssdk.services.appflow.model.PrefixType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrefixConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrefixConfig> {
    private static final SdkField<String> PREFIX_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prefixType").getter(PrefixConfig.getter(PrefixConfig::prefixTypeAsString)).setter(PrefixConfig.setter(Builder::prefixType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefixType").build()}).build();
    private static final SdkField<String> PREFIX_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prefixFormat").getter(PrefixConfig.getter(PrefixConfig::prefixFormatAsString)).setter(PrefixConfig.setter(Builder::prefixFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefixFormat").build()}).build();
    private static final SdkField<List<String>> PATH_PREFIX_HIERARCHY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pathPrefixHierarchy").getter(PrefixConfig.getter(PrefixConfig::pathPrefixHierarchyAsStrings)).setter(PrefixConfig.setter(Builder::pathPrefixHierarchyWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathPrefixHierarchy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_TYPE_FIELD, PREFIX_FORMAT_FIELD, PATH_PREFIX_HIERARCHY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrefixConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String prefixType;
    private final String prefixFormat;
    private final List<String> pathPrefixHierarchy;

    private PrefixConfig(BuilderImpl builder) {
        this.prefixType = builder.prefixType;
        this.prefixFormat = builder.prefixFormat;
        this.pathPrefixHierarchy = builder.pathPrefixHierarchy;
    }

    public final PrefixType prefixType() {
        return PrefixType.fromValue(this.prefixType);
    }

    public final String prefixTypeAsString() {
        return this.prefixType;
    }

    public final PrefixFormat prefixFormat() {
        return PrefixFormat.fromValue(this.prefixFormat);
    }

    public final String prefixFormatAsString() {
        return this.prefixFormat;
    }

    public final List<PathPrefix> pathPrefixHierarchy() {
        return PathPrefixHierarchyCopier.copyStringToEnum(this.pathPrefixHierarchy);
    }

    public final boolean hasPathPrefixHierarchy() {
        return this.pathPrefixHierarchy != null && !(this.pathPrefixHierarchy instanceof SdkAutoConstructList);
    }

    public final List<String> pathPrefixHierarchyAsStrings() {
        return this.pathPrefixHierarchy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPathPrefixHierarchy() ? this.pathPrefixHierarchyAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixConfig)) {
            return false;
        }
        PrefixConfig other = (PrefixConfig)obj;
        return Objects.equals(this.prefixTypeAsString(), other.prefixTypeAsString()) && Objects.equals(this.prefixFormatAsString(), other.prefixFormatAsString()) && this.hasPathPrefixHierarchy() == other.hasPathPrefixHierarchy() && Objects.equals(this.pathPrefixHierarchyAsStrings(), other.pathPrefixHierarchyAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PrefixConfig").add("PrefixType", (Object)this.prefixTypeAsString()).add("PrefixFormat", (Object)this.prefixFormatAsString()).add("PathPrefixHierarchy", this.hasPathPrefixHierarchy() ? this.pathPrefixHierarchyAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "prefixType": {
                return Optional.ofNullable(clazz.cast(this.prefixTypeAsString()));
            }
            case "prefixFormat": {
                return Optional.ofNullable(clazz.cast(this.prefixFormatAsString()));
            }
            case "pathPrefixHierarchy": {
                return Optional.ofNullable(clazz.cast(this.pathPrefixHierarchyAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("prefixType", PREFIX_TYPE_FIELD);
        map.put("prefixFormat", PREFIX_FORMAT_FIELD);
        map.put("pathPrefixHierarchy", PATH_PREFIX_HIERARCHY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrefixConfig, T> g) {
        return obj -> g.apply((PrefixConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String prefixType;
        private String prefixFormat;
        private List<String> pathPrefixHierarchy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PrefixConfig model) {
            this.prefixType(model.prefixType);
            this.prefixFormat(model.prefixFormat);
            this.pathPrefixHierarchyWithStrings(model.pathPrefixHierarchy);
        }

        public final String getPrefixType() {
            return this.prefixType;
        }

        public final void setPrefixType(String prefixType) {
            this.prefixType = prefixType;
        }

        @Override
        public final Builder prefixType(String prefixType) {
            this.prefixType = prefixType;
            return this;
        }

        @Override
        public final Builder prefixType(PrefixType prefixType) {
            this.prefixType(prefixType == null ? null : prefixType.toString());
            return this;
        }

        public final String getPrefixFormat() {
            return this.prefixFormat;
        }

        public final void setPrefixFormat(String prefixFormat) {
            this.prefixFormat = prefixFormat;
        }

        @Override
        public final Builder prefixFormat(String prefixFormat) {
            this.prefixFormat = prefixFormat;
            return this;
        }

        @Override
        public final Builder prefixFormat(PrefixFormat prefixFormat) {
            this.prefixFormat(prefixFormat == null ? null : prefixFormat.toString());
            return this;
        }

        public final Collection<String> getPathPrefixHierarchy() {
            if (this.pathPrefixHierarchy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pathPrefixHierarchy;
        }

        public final void setPathPrefixHierarchy(Collection<String> pathPrefixHierarchy) {
            this.pathPrefixHierarchy = PathPrefixHierarchyCopier.copy(pathPrefixHierarchy);
        }

        @Override
        public final Builder pathPrefixHierarchyWithStrings(Collection<String> pathPrefixHierarchy) {
            this.pathPrefixHierarchy = PathPrefixHierarchyCopier.copy(pathPrefixHierarchy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathPrefixHierarchyWithStrings(String ... pathPrefixHierarchy) {
            this.pathPrefixHierarchyWithStrings(Arrays.asList(pathPrefixHierarchy));
            return this;
        }

        @Override
        public final Builder pathPrefixHierarchy(Collection<PathPrefix> pathPrefixHierarchy) {
            this.pathPrefixHierarchy = PathPrefixHierarchyCopier.copyEnumToString(pathPrefixHierarchy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathPrefixHierarchy(PathPrefix ... pathPrefixHierarchy) {
            this.pathPrefixHierarchy(Arrays.asList(pathPrefixHierarchy));
            return this;
        }

        public PrefixConfig build() {
            return new PrefixConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrefixConfig> {
        public Builder prefixType(String var1);

        public Builder prefixType(PrefixType var1);

        public Builder prefixFormat(String var1);

        public Builder prefixFormat(PrefixFormat var1);

        public Builder pathPrefixHierarchyWithStrings(Collection<String> var1);

        public Builder pathPrefixHierarchyWithStrings(String ... var1);

        public Builder pathPrefixHierarchy(Collection<PathPrefix> var1);

        public Builder pathPrefixHierarchy(PathPrefix ... var1);
    }
}

