/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.DataPullMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledTriggerProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledTriggerProperties> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduleExpression").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::scheduleExpression)).setter(ScheduledTriggerProperties.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleExpression").build()}).build();
    private static final SdkField<String> DATA_PULL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataPullMode").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::dataPullModeAsString)).setter(ScheduledTriggerProperties.setter(Builder::dataPullMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPullMode").build()}).build();
    private static final SdkField<Instant> SCHEDULE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("scheduleStartTime").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::scheduleStartTime)).setter(ScheduledTriggerProperties.setter(Builder::scheduleStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleStartTime").build()}).build();
    private static final SdkField<Instant> SCHEDULE_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("scheduleEndTime").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::scheduleEndTime)).setter(ScheduledTriggerProperties.setter(Builder::scheduleEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleEndTime").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timezone").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::timezone)).setter(ScheduledTriggerProperties.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()}).build();
    private static final SdkField<Long> SCHEDULE_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("scheduleOffset").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::scheduleOffset)).setter(ScheduledTriggerProperties.setter(Builder::scheduleOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleOffset").build()}).build();
    private static final SdkField<Instant> FIRST_EXECUTION_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstExecutionFrom").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::firstExecutionFrom)).setter(ScheduledTriggerProperties.setter(Builder::firstExecutionFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstExecutionFrom").build()}).build();
    private static final SdkField<Integer> FLOW_ERROR_DEACTIVATION_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("flowErrorDeactivationThreshold").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::flowErrorDeactivationThreshold)).setter(ScheduledTriggerProperties.setter(Builder::flowErrorDeactivationThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowErrorDeactivationThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD, DATA_PULL_MODE_FIELD, SCHEDULE_START_TIME_FIELD, SCHEDULE_END_TIME_FIELD, TIMEZONE_FIELD, SCHEDULE_OFFSET_FIELD, FIRST_EXECUTION_FROM_FIELD, FLOW_ERROR_DEACTIVATION_THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("scheduleExpression", SCHEDULE_EXPRESSION_FIELD);
            this.put("dataPullMode", DATA_PULL_MODE_FIELD);
            this.put("scheduleStartTime", SCHEDULE_START_TIME_FIELD);
            this.put("scheduleEndTime", SCHEDULE_END_TIME_FIELD);
            this.put("timezone", TIMEZONE_FIELD);
            this.put("scheduleOffset", SCHEDULE_OFFSET_FIELD);
            this.put("firstExecutionFrom", FIRST_EXECUTION_FROM_FIELD);
            this.put("flowErrorDeactivationThreshold", FLOW_ERROR_DEACTIVATION_THRESHOLD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String scheduleExpression;
    private final String dataPullMode;
    private final Instant scheduleStartTime;
    private final Instant scheduleEndTime;
    private final String timezone;
    private final Long scheduleOffset;
    private final Instant firstExecutionFrom;
    private final Integer flowErrorDeactivationThreshold;

    private ScheduledTriggerProperties(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.dataPullMode = builder.dataPullMode;
        this.scheduleStartTime = builder.scheduleStartTime;
        this.scheduleEndTime = builder.scheduleEndTime;
        this.timezone = builder.timezone;
        this.scheduleOffset = builder.scheduleOffset;
        this.firstExecutionFrom = builder.firstExecutionFrom;
        this.flowErrorDeactivationThreshold = builder.flowErrorDeactivationThreshold;
    }

    public final String scheduleExpression() {
        return this.scheduleExpression;
    }

    public final DataPullMode dataPullMode() {
        return DataPullMode.fromValue(this.dataPullMode);
    }

    public final String dataPullModeAsString() {
        return this.dataPullMode;
    }

    public final Instant scheduleStartTime() {
        return this.scheduleStartTime;
    }

    public final Instant scheduleEndTime() {
        return this.scheduleEndTime;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final Long scheduleOffset() {
        return this.scheduleOffset;
    }

    public final Instant firstExecutionFrom() {
        return this.firstExecutionFrom;
    }

    public final Integer flowErrorDeactivationThreshold() {
        return this.flowErrorDeactivationThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPullModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstExecutionFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowErrorDeactivationThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledTriggerProperties)) {
            return false;
        }
        ScheduledTriggerProperties other = (ScheduledTriggerProperties)obj;
        return Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.dataPullModeAsString(), other.dataPullModeAsString()) && Objects.equals(this.scheduleStartTime(), other.scheduleStartTime()) && Objects.equals(this.scheduleEndTime(), other.scheduleEndTime()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.scheduleOffset(), other.scheduleOffset()) && Objects.equals(this.firstExecutionFrom(), other.firstExecutionFrom()) && Objects.equals(this.flowErrorDeactivationThreshold(), other.flowErrorDeactivationThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledTriggerProperties").add("ScheduleExpression", (Object)this.scheduleExpression()).add("DataPullMode", (Object)this.dataPullModeAsString()).add("ScheduleStartTime", (Object)this.scheduleStartTime()).add("ScheduleEndTime", (Object)this.scheduleEndTime()).add("Timezone", (Object)this.timezone()).add("ScheduleOffset", (Object)this.scheduleOffset()).add("FirstExecutionFrom", (Object)this.firstExecutionFrom()).add("FlowErrorDeactivationThreshold", (Object)this.flowErrorDeactivationThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "dataPullMode": {
                return Optional.ofNullable(clazz.cast(this.dataPullModeAsString()));
            }
            case "scheduleStartTime": {
                return Optional.ofNullable(clazz.cast(this.scheduleStartTime()));
            }
            case "scheduleEndTime": {
                return Optional.ofNullable(clazz.cast(this.scheduleEndTime()));
            }
            case "timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "scheduleOffset": {
                return Optional.ofNullable(clazz.cast(this.scheduleOffset()));
            }
            case "firstExecutionFrom": {
                return Optional.ofNullable(clazz.cast(this.firstExecutionFrom()));
            }
            case "flowErrorDeactivationThreshold": {
                return Optional.ofNullable(clazz.cast(this.flowErrorDeactivationThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledTriggerProperties, T> g) {
        return obj -> g.apply((ScheduledTriggerProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scheduleExpression;
        private String dataPullMode;
        private Instant scheduleStartTime;
        private Instant scheduleEndTime;
        private String timezone;
        private Long scheduleOffset;
        private Instant firstExecutionFrom;
        private Integer flowErrorDeactivationThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledTriggerProperties model) {
            this.scheduleExpression(model.scheduleExpression);
            this.dataPullMode(model.dataPullMode);
            this.scheduleStartTime(model.scheduleStartTime);
            this.scheduleEndTime(model.scheduleEndTime);
            this.timezone(model.timezone);
            this.scheduleOffset(model.scheduleOffset);
            this.firstExecutionFrom(model.firstExecutionFrom);
            this.flowErrorDeactivationThreshold(model.flowErrorDeactivationThreshold);
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getDataPullMode() {
            return this.dataPullMode;
        }

        public final void setDataPullMode(String dataPullMode) {
            this.dataPullMode = dataPullMode;
        }

        @Override
        public final Builder dataPullMode(String dataPullMode) {
            this.dataPullMode = dataPullMode;
            return this;
        }

        @Override
        public final Builder dataPullMode(DataPullMode dataPullMode) {
            this.dataPullMode(dataPullMode == null ? null : dataPullMode.toString());
            return this;
        }

        public final Instant getScheduleStartTime() {
            return this.scheduleStartTime;
        }

        public final void setScheduleStartTime(Instant scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
        }

        @Override
        public final Builder scheduleStartTime(Instant scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
            return this;
        }

        public final Instant getScheduleEndTime() {
            return this.scheduleEndTime;
        }

        public final void setScheduleEndTime(Instant scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
        }

        @Override
        public final Builder scheduleEndTime(Instant scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Long getScheduleOffset() {
            return this.scheduleOffset;
        }

        public final void setScheduleOffset(Long scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        @Override
        public final Builder scheduleOffset(Long scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final Instant getFirstExecutionFrom() {
            return this.firstExecutionFrom;
        }

        public final void setFirstExecutionFrom(Instant firstExecutionFrom) {
            this.firstExecutionFrom = firstExecutionFrom;
        }

        @Override
        public final Builder firstExecutionFrom(Instant firstExecutionFrom) {
            this.firstExecutionFrom = firstExecutionFrom;
            return this;
        }

        public final Integer getFlowErrorDeactivationThreshold() {
            return this.flowErrorDeactivationThreshold;
        }

        public final void setFlowErrorDeactivationThreshold(Integer flowErrorDeactivationThreshold) {
            this.flowErrorDeactivationThreshold = flowErrorDeactivationThreshold;
        }

        @Override
        public final Builder flowErrorDeactivationThreshold(Integer flowErrorDeactivationThreshold) {
            this.flowErrorDeactivationThreshold = flowErrorDeactivationThreshold;
            return this;
        }

        public ScheduledTriggerProperties build() {
            return new ScheduledTriggerProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledTriggerProperties> {
        public Builder scheduleExpression(String var1);

        public Builder dataPullMode(String var1);

        public Builder dataPullMode(DataPullMode var1);

        public Builder scheduleStartTime(Instant var1);

        public Builder scheduleEndTime(Instant var1);

        public Builder timezone(String var1);

        public Builder scheduleOffset(Long var1);

        public Builder firstExecutionFrom(Instant var1);

        public Builder flowErrorDeactivationThreshold(Integer var1);
    }
}

