/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appflow.AppflowClient;
import software.amazon.awssdk.services.appflow.internal.UserAgentUtils;
import software.amazon.awssdk.services.appflow.model.ListFlowsRequest;
import software.amazon.awssdk.services.appflow.model.ListFlowsResponse;

public class ListFlowsIterable
implements SdkIterable<ListFlowsResponse> {
    private final AppflowClient client;
    private final ListFlowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlowsIterable(AppflowClient client, ListFlowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFlowsResponseFetcher();
    }

    public Iterator<ListFlowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFlowsResponseFetcher
    implements SyncPageFetcher<ListFlowsResponse> {
        private ListFlowsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlowsResponse nextPage(ListFlowsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowsIterable.this.client.listFlows(ListFlowsIterable.this.firstRequest);
            }
            return ListFlowsIterable.this.client.listFlows((ListFlowsRequest)((Object)ListFlowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

