/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.OAuth2Credentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceNowConnectorProfileCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceNowConnectorProfileCredentials> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(ServiceNowConnectorProfileCredentials.getter(ServiceNowConnectorProfileCredentials::username)).setter(ServiceNowConnectorProfileCredentials.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("password").getter(ServiceNowConnectorProfileCredentials.getter(ServiceNowConnectorProfileCredentials::password)).setter(ServiceNowConnectorProfileCredentials.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()}).build();
    private static final SdkField<OAuth2Credentials> O_AUTH2_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuth2Credentials").getter(ServiceNowConnectorProfileCredentials.getter(ServiceNowConnectorProfileCredentials::oAuth2Credentials)).setter(ServiceNowConnectorProfileCredentials.setter(Builder::oAuth2Credentials)).constructor(OAuth2Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2Credentials").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, PASSWORD_FIELD, O_AUTH2_CREDENTIALS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String password;
    private final OAuth2Credentials oAuth2Credentials;

    private ServiceNowConnectorProfileCredentials(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.oAuth2Credentials = builder.oAuth2Credentials;
    }

    public final String username() {
        return this.username;
    }

    public final String password() {
        return this.password;
    }

    public final OAuth2Credentials oAuth2Credentials() {
        return this.oAuth2Credentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2Credentials());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNowConnectorProfileCredentials)) {
            return false;
        }
        ServiceNowConnectorProfileCredentials other = (ServiceNowConnectorProfileCredentials)obj;
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.oAuth2Credentials(), other.oAuth2Credentials());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceNowConnectorProfileCredentials").add("Username", (Object)this.username()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("OAuth2Credentials", (Object)this.oAuth2Credentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "oAuth2Credentials": {
                return Optional.ofNullable(clazz.cast(this.oAuth2Credentials()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceNowConnectorProfileCredentials, T> g) {
        return obj -> g.apply((ServiceNowConnectorProfileCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String username;
        private String password;
        private OAuth2Credentials oAuth2Credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNowConnectorProfileCredentials model) {
            this.username(model.username);
            this.password(model.password);
            this.oAuth2Credentials(model.oAuth2Credentials);
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final OAuth2Credentials.Builder getOAuth2Credentials() {
            return this.oAuth2Credentials != null ? this.oAuth2Credentials.toBuilder() : null;
        }

        public final void setOAuth2Credentials(OAuth2Credentials.BuilderImpl oAuth2Credentials) {
            this.oAuth2Credentials = oAuth2Credentials != null ? oAuth2Credentials.build() : null;
        }

        @Override
        public final Builder oAuth2Credentials(OAuth2Credentials oAuth2Credentials) {
            this.oAuth2Credentials = oAuth2Credentials;
            return this;
        }

        public ServiceNowConnectorProfileCredentials build() {
            return new ServiceNowConnectorProfileCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceNowConnectorProfileCredentials> {
        public Builder username(String var1);

        public Builder password(String var1);

        public Builder oAuth2Credentials(OAuth2Credentials var1);

        default public Builder oAuth2Credentials(Consumer<OAuth2Credentials.Builder> oAuth2Credentials) {
            return this.oAuth2Credentials((OAuth2Credentials)((OAuth2Credentials.Builder)OAuth2Credentials.builder().applyMutation(oAuth2Credentials)).build());
        }
    }
}

