/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appflow.AppflowAsyncClient;
import software.amazon.awssdk.services.appflow.AppflowAsyncClientBuilder;
import software.amazon.awssdk.services.appflow.AppflowServiceClientConfiguration;
import software.amazon.awssdk.services.appflow.DefaultAppflowAsyncClient;
import software.amazon.awssdk.services.appflow.DefaultAppflowBaseClientBuilder;
import software.amazon.awssdk.services.appflow.endpoints.AppflowEndpointProvider;

@SdkInternalApi
final class DefaultAppflowAsyncClientBuilder
extends DefaultAppflowBaseClientBuilder<AppflowAsyncClientBuilder, AppflowAsyncClient>
implements AppflowAsyncClientBuilder {
    DefaultAppflowAsyncClientBuilder() {
    }

    @Override
    public DefaultAppflowAsyncClientBuilder endpointProvider(AppflowEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppflowAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAppflowAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AppflowServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAppflowAsyncClient client = new DefaultAppflowAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AppflowServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AppflowServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

