/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.services.appflow.model.DestinationConnectorProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationFlowConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationFlowConfig> {
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorType").getter(DestinationFlowConfig.getter(DestinationFlowConfig::connectorTypeAsString)).setter(DestinationFlowConfig.setter(Builder::connectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()}).build();
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorProfileName").getter(DestinationFlowConfig.getter(DestinationFlowConfig::connectorProfileName)).setter(DestinationFlowConfig.setter(Builder::connectorProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build()}).build();
    private static final SdkField<DestinationConnectorProperties> DESTINATION_CONNECTOR_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationConnectorProperties").getter(DestinationFlowConfig.getter(DestinationFlowConfig::destinationConnectorProperties)).setter(DestinationFlowConfig.setter(Builder::destinationConnectorProperties)).constructor(DestinationConnectorProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConnectorProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_TYPE_FIELD, CONNECTOR_PROFILE_NAME_FIELD, DESTINATION_CONNECTOR_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String connectorType;
    private final String connectorProfileName;
    private final DestinationConnectorProperties destinationConnectorProperties;

    private DestinationFlowConfig(BuilderImpl builder) {
        this.connectorType = builder.connectorType;
        this.connectorProfileName = builder.connectorProfileName;
        this.destinationConnectorProperties = builder.destinationConnectorProperties;
    }

    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(this.connectorType);
    }

    public final String connectorTypeAsString() {
        return this.connectorType;
    }

    public final String connectorProfileName() {
        return this.connectorProfileName;
    }

    public final DestinationConnectorProperties destinationConnectorProperties() {
        return this.destinationConnectorProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConnectorProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationFlowConfig)) {
            return false;
        }
        DestinationFlowConfig other = (DestinationFlowConfig)obj;
        return Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.connectorProfileName(), other.connectorProfileName()) && Objects.equals(this.destinationConnectorProperties(), other.destinationConnectorProperties());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationFlowConfig").add("ConnectorType", (Object)this.connectorTypeAsString()).add("ConnectorProfileName", (Object)this.connectorProfileName()).add("DestinationConnectorProperties", (Object)this.destinationConnectorProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "connectorProfileName": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileName()));
            }
            case "destinationConnectorProperties": {
                return Optional.ofNullable(clazz.cast(this.destinationConnectorProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationFlowConfig, T> g) {
        return obj -> g.apply((DestinationFlowConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorType;
        private String connectorProfileName;
        private DestinationConnectorProperties destinationConnectorProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationFlowConfig model) {
            this.connectorType(model.connectorType);
            this.connectorProfileName(model.connectorProfileName);
            this.destinationConnectorProperties(model.destinationConnectorProperties);
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        @Transient
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        @Transient
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorProfileName() {
            return this.connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        @Transient
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final DestinationConnectorProperties.Builder getDestinationConnectorProperties() {
            return this.destinationConnectorProperties != null ? this.destinationConnectorProperties.toBuilder() : null;
        }

        public final void setDestinationConnectorProperties(DestinationConnectorProperties.BuilderImpl destinationConnectorProperties) {
            this.destinationConnectorProperties = destinationConnectorProperties != null ? destinationConnectorProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationConnectorProperties(DestinationConnectorProperties destinationConnectorProperties) {
            this.destinationConnectorProperties = destinationConnectorProperties;
            return this;
        }

        public DestinationFlowConfig build() {
            return new DestinationFlowConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationFlowConfig> {
        public Builder connectorType(String var1);

        public Builder connectorType(ConnectorType var1);

        public Builder connectorProfileName(String var1);

        public Builder destinationConnectorProperties(DestinationConnectorProperties var1);

        default public Builder destinationConnectorProperties(Consumer<DestinationConnectorProperties.Builder> destinationConnectorProperties) {
            return this.destinationConnectorProperties((DestinationConnectorProperties)((DestinationConnectorProperties.Builder)DestinationConnectorProperties.builder().applyMutation(destinationConnectorProperties)).build());
        }
    }
}

