/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.ErrorHandlingConfig;
import software.amazon.awssdk.services.appflow.model.IdFieldNameListCopier;
import software.amazon.awssdk.services.appflow.model.SuccessResponseHandlingConfig;
import software.amazon.awssdk.services.appflow.model.WriteOperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SAPODataDestinationProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SAPODataDestinationProperties> {
    private static final SdkField<String> OBJECT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objectPath").getter(SAPODataDestinationProperties.getter(SAPODataDestinationProperties::objectPath)).setter(SAPODataDestinationProperties.setter(Builder::objectPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectPath").build()}).build();
    private static final SdkField<SuccessResponseHandlingConfig> SUCCESS_RESPONSE_HANDLING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("successResponseHandlingConfig").getter(SAPODataDestinationProperties.getter(SAPODataDestinationProperties::successResponseHandlingConfig)).setter(SAPODataDestinationProperties.setter(Builder::successResponseHandlingConfig)).constructor(SuccessResponseHandlingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successResponseHandlingConfig").build()}).build();
    private static final SdkField<List<String>> ID_FIELD_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("idFieldNames").getter(SAPODataDestinationProperties.getter(SAPODataDestinationProperties::idFieldNames)).setter(SAPODataDestinationProperties.setter(Builder::idFieldNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idFieldNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ErrorHandlingConfig> ERROR_HANDLING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorHandlingConfig").getter(SAPODataDestinationProperties.getter(SAPODataDestinationProperties::errorHandlingConfig)).setter(SAPODataDestinationProperties.setter(Builder::errorHandlingConfig)).constructor(ErrorHandlingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorHandlingConfig").build()}).build();
    private static final SdkField<String> WRITE_OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("writeOperationType").getter(SAPODataDestinationProperties.getter(SAPODataDestinationProperties::writeOperationTypeAsString)).setter(SAPODataDestinationProperties.setter(Builder::writeOperationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeOperationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_PATH_FIELD, SUCCESS_RESPONSE_HANDLING_CONFIG_FIELD, ID_FIELD_NAMES_FIELD, ERROR_HANDLING_CONFIG_FIELD, WRITE_OPERATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String objectPath;
    private final SuccessResponseHandlingConfig successResponseHandlingConfig;
    private final List<String> idFieldNames;
    private final ErrorHandlingConfig errorHandlingConfig;
    private final String writeOperationType;

    private SAPODataDestinationProperties(BuilderImpl builder) {
        this.objectPath = builder.objectPath;
        this.successResponseHandlingConfig = builder.successResponseHandlingConfig;
        this.idFieldNames = builder.idFieldNames;
        this.errorHandlingConfig = builder.errorHandlingConfig;
        this.writeOperationType = builder.writeOperationType;
    }

    public final String objectPath() {
        return this.objectPath;
    }

    public final SuccessResponseHandlingConfig successResponseHandlingConfig() {
        return this.successResponseHandlingConfig;
    }

    public final boolean hasIdFieldNames() {
        return this.idFieldNames != null && !(this.idFieldNames instanceof SdkAutoConstructList);
    }

    public final List<String> idFieldNames() {
        return this.idFieldNames;
    }

    public final ErrorHandlingConfig errorHandlingConfig() {
        return this.errorHandlingConfig;
    }

    public final WriteOperationType writeOperationType() {
        return WriteOperationType.fromValue(this.writeOperationType);
    }

    public final String writeOperationTypeAsString() {
        return this.writeOperationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.successResponseHandlingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdFieldNames() ? this.idFieldNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorHandlingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeOperationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAPODataDestinationProperties)) {
            return false;
        }
        SAPODataDestinationProperties other = (SAPODataDestinationProperties)obj;
        return Objects.equals(this.objectPath(), other.objectPath()) && Objects.equals(this.successResponseHandlingConfig(), other.successResponseHandlingConfig()) && this.hasIdFieldNames() == other.hasIdFieldNames() && Objects.equals(this.idFieldNames(), other.idFieldNames()) && Objects.equals(this.errorHandlingConfig(), other.errorHandlingConfig()) && Objects.equals(this.writeOperationTypeAsString(), other.writeOperationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SAPODataDestinationProperties").add("ObjectPath", (Object)this.objectPath()).add("SuccessResponseHandlingConfig", (Object)this.successResponseHandlingConfig()).add("IdFieldNames", this.hasIdFieldNames() ? this.idFieldNames() : null).add("ErrorHandlingConfig", (Object)this.errorHandlingConfig()).add("WriteOperationType", (Object)this.writeOperationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "objectPath": {
                return Optional.ofNullable(clazz.cast(this.objectPath()));
            }
            case "successResponseHandlingConfig": {
                return Optional.ofNullable(clazz.cast(this.successResponseHandlingConfig()));
            }
            case "idFieldNames": {
                return Optional.ofNullable(clazz.cast(this.idFieldNames()));
            }
            case "errorHandlingConfig": {
                return Optional.ofNullable(clazz.cast(this.errorHandlingConfig()));
            }
            case "writeOperationType": {
                return Optional.ofNullable(clazz.cast(this.writeOperationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SAPODataDestinationProperties, T> g) {
        return obj -> g.apply((SAPODataDestinationProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String objectPath;
        private SuccessResponseHandlingConfig successResponseHandlingConfig;
        private List<String> idFieldNames = DefaultSdkAutoConstructList.getInstance();
        private ErrorHandlingConfig errorHandlingConfig;
        private String writeOperationType;

        private BuilderImpl() {
        }

        private BuilderImpl(SAPODataDestinationProperties model) {
            this.objectPath(model.objectPath);
            this.successResponseHandlingConfig(model.successResponseHandlingConfig);
            this.idFieldNames(model.idFieldNames);
            this.errorHandlingConfig(model.errorHandlingConfig);
            this.writeOperationType(model.writeOperationType);
        }

        public final String getObjectPath() {
            return this.objectPath;
        }

        public final void setObjectPath(String objectPath) {
            this.objectPath = objectPath;
        }

        @Override
        @Transient
        public final Builder objectPath(String objectPath) {
            this.objectPath = objectPath;
            return this;
        }

        public final SuccessResponseHandlingConfig.Builder getSuccessResponseHandlingConfig() {
            return this.successResponseHandlingConfig != null ? this.successResponseHandlingConfig.toBuilder() : null;
        }

        public final void setSuccessResponseHandlingConfig(SuccessResponseHandlingConfig.BuilderImpl successResponseHandlingConfig) {
            this.successResponseHandlingConfig = successResponseHandlingConfig != null ? successResponseHandlingConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder successResponseHandlingConfig(SuccessResponseHandlingConfig successResponseHandlingConfig) {
            this.successResponseHandlingConfig = successResponseHandlingConfig;
            return this;
        }

        public final Collection<String> getIdFieldNames() {
            if (this.idFieldNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.idFieldNames;
        }

        public final void setIdFieldNames(Collection<String> idFieldNames) {
            this.idFieldNames = IdFieldNameListCopier.copy(idFieldNames);
        }

        @Override
        @Transient
        public final Builder idFieldNames(Collection<String> idFieldNames) {
            this.idFieldNames = IdFieldNameListCopier.copy(idFieldNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder idFieldNames(String ... idFieldNames) {
            this.idFieldNames(Arrays.asList(idFieldNames));
            return this;
        }

        public final ErrorHandlingConfig.Builder getErrorHandlingConfig() {
            return this.errorHandlingConfig != null ? this.errorHandlingConfig.toBuilder() : null;
        }

        public final void setErrorHandlingConfig(ErrorHandlingConfig.BuilderImpl errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig != null ? errorHandlingConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig;
            return this;
        }

        public final String getWriteOperationType() {
            return this.writeOperationType;
        }

        public final void setWriteOperationType(String writeOperationType) {
            this.writeOperationType = writeOperationType;
        }

        @Override
        @Transient
        public final Builder writeOperationType(String writeOperationType) {
            this.writeOperationType = writeOperationType;
            return this;
        }

        @Override
        @Transient
        public final Builder writeOperationType(WriteOperationType writeOperationType) {
            this.writeOperationType(writeOperationType == null ? null : writeOperationType.toString());
            return this;
        }

        public SAPODataDestinationProperties build() {
            return new SAPODataDestinationProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SAPODataDestinationProperties> {
        public Builder objectPath(String var1);

        public Builder successResponseHandlingConfig(SuccessResponseHandlingConfig var1);

        default public Builder successResponseHandlingConfig(Consumer<SuccessResponseHandlingConfig.Builder> successResponseHandlingConfig) {
            return this.successResponseHandlingConfig((SuccessResponseHandlingConfig)((SuccessResponseHandlingConfig.Builder)SuccessResponseHandlingConfig.builder().applyMutation(successResponseHandlingConfig)).build());
        }

        public Builder idFieldNames(Collection<String> var1);

        public Builder idFieldNames(String ... var1);

        public Builder errorHandlingConfig(ErrorHandlingConfig var1);

        default public Builder errorHandlingConfig(Consumer<ErrorHandlingConfig.Builder> errorHandlingConfig) {
            return this.errorHandlingConfig((ErrorHandlingConfig)((ErrorHandlingConfig.Builder)ErrorHandlingConfig.builder().applyMutation(errorHandlingConfig)).build());
        }

        public Builder writeOperationType(String var1);

        public Builder writeOperationType(WriteOperationType var1);
    }
}

