/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.CustomAuthConfig;
import software.amazon.awssdk.services.appflow.model.CustomAuthConfigListCopier;
import software.amazon.awssdk.services.appflow.model.OAuth2Defaults;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationConfig> {
    private static final SdkField<Boolean> IS_BASIC_AUTH_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isBasicAuthSupported").getter(AuthenticationConfig.getter(AuthenticationConfig::isBasicAuthSupported)).setter(AuthenticationConfig.setter(Builder::isBasicAuthSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isBasicAuthSupported").build()}).build();
    private static final SdkField<Boolean> IS_API_KEY_AUTH_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isApiKeyAuthSupported").getter(AuthenticationConfig.getter(AuthenticationConfig::isApiKeyAuthSupported)).setter(AuthenticationConfig.setter(Builder::isApiKeyAuthSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isApiKeyAuthSupported").build()}).build();
    private static final SdkField<Boolean> IS_O_AUTH2_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isOAuth2Supported").getter(AuthenticationConfig.getter(AuthenticationConfig::isOAuth2Supported)).setter(AuthenticationConfig.setter(Builder::isOAuth2Supported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isOAuth2Supported").build()}).build();
    private static final SdkField<Boolean> IS_CUSTOM_AUTH_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isCustomAuthSupported").getter(AuthenticationConfig.getter(AuthenticationConfig::isCustomAuthSupported)).setter(AuthenticationConfig.setter(Builder::isCustomAuthSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isCustomAuthSupported").build()}).build();
    private static final SdkField<OAuth2Defaults> O_AUTH2_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuth2Defaults").getter(AuthenticationConfig.getter(AuthenticationConfig::oAuth2Defaults)).setter(AuthenticationConfig.setter(Builder::oAuth2Defaults)).constructor(OAuth2Defaults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2Defaults").build()}).build();
    private static final SdkField<List<CustomAuthConfig>> CUSTOM_AUTH_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customAuthConfigs").getter(AuthenticationConfig.getter(AuthenticationConfig::customAuthConfigs)).setter(AuthenticationConfig.setter(Builder::customAuthConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAuthConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomAuthConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_BASIC_AUTH_SUPPORTED_FIELD, IS_API_KEY_AUTH_SUPPORTED_FIELD, IS_O_AUTH2_SUPPORTED_FIELD, IS_CUSTOM_AUTH_SUPPORTED_FIELD, O_AUTH2_DEFAULTS_FIELD, CUSTOM_AUTH_CONFIGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean isBasicAuthSupported;
    private final Boolean isApiKeyAuthSupported;
    private final Boolean isOAuth2Supported;
    private final Boolean isCustomAuthSupported;
    private final OAuth2Defaults oAuth2Defaults;
    private final List<CustomAuthConfig> customAuthConfigs;

    private AuthenticationConfig(BuilderImpl builder) {
        this.isBasicAuthSupported = builder.isBasicAuthSupported;
        this.isApiKeyAuthSupported = builder.isApiKeyAuthSupported;
        this.isOAuth2Supported = builder.isOAuth2Supported;
        this.isCustomAuthSupported = builder.isCustomAuthSupported;
        this.oAuth2Defaults = builder.oAuth2Defaults;
        this.customAuthConfigs = builder.customAuthConfigs;
    }

    public final Boolean isBasicAuthSupported() {
        return this.isBasicAuthSupported;
    }

    public final Boolean isApiKeyAuthSupported() {
        return this.isApiKeyAuthSupported;
    }

    public final Boolean isOAuth2Supported() {
        return this.isOAuth2Supported;
    }

    public final Boolean isCustomAuthSupported() {
        return this.isCustomAuthSupported;
    }

    public final OAuth2Defaults oAuth2Defaults() {
        return this.oAuth2Defaults;
    }

    public final boolean hasCustomAuthConfigs() {
        return this.customAuthConfigs != null && !(this.customAuthConfigs instanceof SdkAutoConstructList);
    }

    public final List<CustomAuthConfig> customAuthConfigs() {
        return this.customAuthConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isBasicAuthSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.isApiKeyAuthSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.isOAuth2Supported());
        hashCode = 31 * hashCode + Objects.hashCode(this.isCustomAuthSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2Defaults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAuthConfigs() ? this.customAuthConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfig)) {
            return false;
        }
        AuthenticationConfig other = (AuthenticationConfig)obj;
        return Objects.equals(this.isBasicAuthSupported(), other.isBasicAuthSupported()) && Objects.equals(this.isApiKeyAuthSupported(), other.isApiKeyAuthSupported()) && Objects.equals(this.isOAuth2Supported(), other.isOAuth2Supported()) && Objects.equals(this.isCustomAuthSupported(), other.isCustomAuthSupported()) && Objects.equals(this.oAuth2Defaults(), other.oAuth2Defaults()) && this.hasCustomAuthConfigs() == other.hasCustomAuthConfigs() && Objects.equals(this.customAuthConfigs(), other.customAuthConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationConfig").add("IsBasicAuthSupported", (Object)this.isBasicAuthSupported()).add("IsApiKeyAuthSupported", (Object)this.isApiKeyAuthSupported()).add("IsOAuth2Supported", (Object)this.isOAuth2Supported()).add("IsCustomAuthSupported", (Object)this.isCustomAuthSupported()).add("OAuth2Defaults", (Object)this.oAuth2Defaults()).add("CustomAuthConfigs", this.hasCustomAuthConfigs() ? this.customAuthConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isBasicAuthSupported": {
                return Optional.ofNullable(clazz.cast(this.isBasicAuthSupported()));
            }
            case "isApiKeyAuthSupported": {
                return Optional.ofNullable(clazz.cast(this.isApiKeyAuthSupported()));
            }
            case "isOAuth2Supported": {
                return Optional.ofNullable(clazz.cast(this.isOAuth2Supported()));
            }
            case "isCustomAuthSupported": {
                return Optional.ofNullable(clazz.cast(this.isCustomAuthSupported()));
            }
            case "oAuth2Defaults": {
                return Optional.ofNullable(clazz.cast(this.oAuth2Defaults()));
            }
            case "customAuthConfigs": {
                return Optional.ofNullable(clazz.cast(this.customAuthConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfig, T> g) {
        return obj -> g.apply((AuthenticationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isBasicAuthSupported;
        private Boolean isApiKeyAuthSupported;
        private Boolean isOAuth2Supported;
        private Boolean isCustomAuthSupported;
        private OAuth2Defaults oAuth2Defaults;
        private List<CustomAuthConfig> customAuthConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfig model) {
            this.isBasicAuthSupported(model.isBasicAuthSupported);
            this.isApiKeyAuthSupported(model.isApiKeyAuthSupported);
            this.isOAuth2Supported(model.isOAuth2Supported);
            this.isCustomAuthSupported(model.isCustomAuthSupported);
            this.oAuth2Defaults(model.oAuth2Defaults);
            this.customAuthConfigs(model.customAuthConfigs);
        }

        public final Boolean getIsBasicAuthSupported() {
            return this.isBasicAuthSupported;
        }

        public final void setIsBasicAuthSupported(Boolean isBasicAuthSupported) {
            this.isBasicAuthSupported = isBasicAuthSupported;
        }

        @Override
        @Transient
        public final Builder isBasicAuthSupported(Boolean isBasicAuthSupported) {
            this.isBasicAuthSupported = isBasicAuthSupported;
            return this;
        }

        public final Boolean getIsApiKeyAuthSupported() {
            return this.isApiKeyAuthSupported;
        }

        public final void setIsApiKeyAuthSupported(Boolean isApiKeyAuthSupported) {
            this.isApiKeyAuthSupported = isApiKeyAuthSupported;
        }

        @Override
        @Transient
        public final Builder isApiKeyAuthSupported(Boolean isApiKeyAuthSupported) {
            this.isApiKeyAuthSupported = isApiKeyAuthSupported;
            return this;
        }

        public final Boolean getIsOAuth2Supported() {
            return this.isOAuth2Supported;
        }

        public final void setIsOAuth2Supported(Boolean isOAuth2Supported) {
            this.isOAuth2Supported = isOAuth2Supported;
        }

        @Override
        @Transient
        public final Builder isOAuth2Supported(Boolean isOAuth2Supported) {
            this.isOAuth2Supported = isOAuth2Supported;
            return this;
        }

        public final Boolean getIsCustomAuthSupported() {
            return this.isCustomAuthSupported;
        }

        public final void setIsCustomAuthSupported(Boolean isCustomAuthSupported) {
            this.isCustomAuthSupported = isCustomAuthSupported;
        }

        @Override
        @Transient
        public final Builder isCustomAuthSupported(Boolean isCustomAuthSupported) {
            this.isCustomAuthSupported = isCustomAuthSupported;
            return this;
        }

        public final OAuth2Defaults.Builder getOAuth2Defaults() {
            return this.oAuth2Defaults != null ? this.oAuth2Defaults.toBuilder() : null;
        }

        public final void setOAuth2Defaults(OAuth2Defaults.BuilderImpl oAuth2Defaults) {
            this.oAuth2Defaults = oAuth2Defaults != null ? oAuth2Defaults.build() : null;
        }

        @Override
        @Transient
        public final Builder oAuth2Defaults(OAuth2Defaults oAuth2Defaults) {
            this.oAuth2Defaults = oAuth2Defaults;
            return this;
        }

        public final List<CustomAuthConfig.Builder> getCustomAuthConfigs() {
            List<CustomAuthConfig.Builder> result = CustomAuthConfigListCopier.copyToBuilder(this.customAuthConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAuthConfigs(Collection<CustomAuthConfig.BuilderImpl> customAuthConfigs) {
            this.customAuthConfigs = CustomAuthConfigListCopier.copyFromBuilder(customAuthConfigs);
        }

        @Override
        @Transient
        public final Builder customAuthConfigs(Collection<CustomAuthConfig> customAuthConfigs) {
            this.customAuthConfigs = CustomAuthConfigListCopier.copy(customAuthConfigs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customAuthConfigs(CustomAuthConfig ... customAuthConfigs) {
            this.customAuthConfigs(Arrays.asList(customAuthConfigs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customAuthConfigs(Consumer<CustomAuthConfig.Builder> ... customAuthConfigs) {
            this.customAuthConfigs(Stream.of(customAuthConfigs).map(c -> (CustomAuthConfig)((CustomAuthConfig.Builder)CustomAuthConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AuthenticationConfig build() {
            return new AuthenticationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationConfig> {
        public Builder isBasicAuthSupported(Boolean var1);

        public Builder isApiKeyAuthSupported(Boolean var1);

        public Builder isOAuth2Supported(Boolean var1);

        public Builder isCustomAuthSupported(Boolean var1);

        public Builder oAuth2Defaults(OAuth2Defaults var1);

        default public Builder oAuth2Defaults(Consumer<OAuth2Defaults.Builder> oAuth2Defaults) {
            return this.oAuth2Defaults((OAuth2Defaults)((OAuth2Defaults.Builder)OAuth2Defaults.builder().applyMutation(oAuth2Defaults)).build());
        }

        public Builder customAuthConfigs(Collection<CustomAuthConfig> var1);

        public Builder customAuthConfigs(CustomAuthConfig ... var1);

        public Builder customAuthConfigs(Consumer<CustomAuthConfig.Builder> ... var1);
    }
}

