/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConnectorEntitiesRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, ListConnectorEntitiesRequest> {
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorProfileName").getter(ListConnectorEntitiesRequest.getter(ListConnectorEntitiesRequest::connectorProfileName)).setter(ListConnectorEntitiesRequest.setter(Builder::connectorProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build()}).build();
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorType").getter(ListConnectorEntitiesRequest.getter(ListConnectorEntitiesRequest::connectorTypeAsString)).setter(ListConnectorEntitiesRequest.setter(Builder::connectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()}).build();
    private static final SdkField<String> ENTITIES_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entitiesPath").getter(ListConnectorEntitiesRequest.getter(ListConnectorEntitiesRequest::entitiesPath)).setter(ListConnectorEntitiesRequest.setter(Builder::entitiesPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitiesPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_NAME_FIELD, CONNECTOR_TYPE_FIELD, ENTITIES_PATH_FIELD));
    private final String connectorProfileName;
    private final String connectorType;
    private final String entitiesPath;

    private ListConnectorEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.connectorProfileName = builder.connectorProfileName;
        this.connectorType = builder.connectorType;
        this.entitiesPath = builder.entitiesPath;
    }

    public final String connectorProfileName() {
        return this.connectorProfileName;
    }

    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(this.connectorType);
    }

    public final String connectorTypeAsString() {
        return this.connectorType;
    }

    public final String entitiesPath() {
        return this.entitiesPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitiesPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectorEntitiesRequest)) {
            return false;
        }
        ListConnectorEntitiesRequest other = (ListConnectorEntitiesRequest)((Object)obj);
        return Objects.equals(this.connectorProfileName(), other.connectorProfileName()) && Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.entitiesPath(), other.entitiesPath());
    }

    public final String toString() {
        return ToString.builder((String)"ListConnectorEntitiesRequest").add("ConnectorProfileName", (Object)this.connectorProfileName()).add("ConnectorType", (Object)this.connectorTypeAsString()).add("EntitiesPath", (Object)this.entitiesPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorProfileName": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileName()));
            }
            case "connectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "entitiesPath": {
                return Optional.ofNullable(clazz.cast(this.entitiesPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConnectorEntitiesRequest, T> g) {
        return obj -> g.apply((ListConnectorEntitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private String connectorProfileName;
        private String connectorType;
        private String entitiesPath;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectorEntitiesRequest model) {
            super(model);
            this.connectorProfileName(model.connectorProfileName);
            this.connectorType(model.connectorType);
            this.entitiesPath(model.entitiesPath);
        }

        public final String getConnectorProfileName() {
            return this.connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        @Transient
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        @Transient
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        @Transient
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getEntitiesPath() {
            return this.entitiesPath;
        }

        public final void setEntitiesPath(String entitiesPath) {
            this.entitiesPath = entitiesPath;
        }

        @Override
        @Transient
        public final Builder entitiesPath(String entitiesPath) {
            this.entitiesPath = entitiesPath;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConnectorEntitiesRequest build() {
            return new ListConnectorEntitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConnectorEntitiesRequest> {
        public Builder connectorProfileName(String var1);

        public Builder connectorType(String var1);

        public Builder connectorType(ConnectorType var1);

        public Builder entitiesPath(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

