/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceNowConnectorProfileCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceNowConnectorProfileCredentials> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(ServiceNowConnectorProfileCredentials.getter(ServiceNowConnectorProfileCredentials::username)).setter(ServiceNowConnectorProfileCredentials.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("password").getter(ServiceNowConnectorProfileCredentials.getter(ServiceNowConnectorProfileCredentials::password)).setter(ServiceNowConnectorProfileCredentials.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, PASSWORD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String password;

    private ServiceNowConnectorProfileCredentials(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNowConnectorProfileCredentials)) {
            return false;
        }
        ServiceNowConnectorProfileCredentials other = (ServiceNowConnectorProfileCredentials)obj;
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password());
    }

    public String toString() {
        return ToString.builder((String)"ServiceNowConnectorProfileCredentials").add("Username", (Object)this.username()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceNowConnectorProfileCredentials, T> g) {
        return obj -> g.apply((ServiceNowConnectorProfileCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String username;
        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNowConnectorProfileCredentials model) {
            this.username(model.username);
            this.password(model.password);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public ServiceNowConnectorProfileCredentials build() {
            return new ServiceNowConnectorProfileCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceNowConnectorProfileCredentials> {
        public Builder username(String var1);

        public Builder password(String var1);
    }
}

