/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SalesforceConnectorProfileProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SalesforceConnectorProfileProperties> {
    private static final SdkField<String> INSTANCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceUrl").getter(SalesforceConnectorProfileProperties.getter(SalesforceConnectorProfileProperties::instanceUrl)).setter(SalesforceConnectorProfileProperties.setter(Builder::instanceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceUrl").build()}).build();
    private static final SdkField<Boolean> IS_SANDBOX_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSandboxEnvironment").getter(SalesforceConnectorProfileProperties.getter(SalesforceConnectorProfileProperties::isSandboxEnvironment)).setter(SalesforceConnectorProfileProperties.setter(Builder::isSandboxEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSandboxEnvironment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_URL_FIELD, IS_SANDBOX_ENVIRONMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceUrl;
    private final Boolean isSandboxEnvironment;

    private SalesforceConnectorProfileProperties(BuilderImpl builder) {
        this.instanceUrl = builder.instanceUrl;
        this.isSandboxEnvironment = builder.isSandboxEnvironment;
    }

    public String instanceUrl() {
        return this.instanceUrl;
    }

    public Boolean isSandboxEnvironment() {
        return this.isSandboxEnvironment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSandboxEnvironment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceConnectorProfileProperties)) {
            return false;
        }
        SalesforceConnectorProfileProperties other = (SalesforceConnectorProfileProperties)obj;
        return Objects.equals(this.instanceUrl(), other.instanceUrl()) && Objects.equals(this.isSandboxEnvironment(), other.isSandboxEnvironment());
    }

    public String toString() {
        return ToString.builder((String)"SalesforceConnectorProfileProperties").add("InstanceUrl", (Object)this.instanceUrl()).add("IsSandboxEnvironment", (Object)this.isSandboxEnvironment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceUrl": {
                return Optional.ofNullable(clazz.cast(this.instanceUrl()));
            }
            case "isSandboxEnvironment": {
                return Optional.ofNullable(clazz.cast(this.isSandboxEnvironment()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceConnectorProfileProperties, T> g) {
        return obj -> g.apply((SalesforceConnectorProfileProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceUrl;
        private Boolean isSandboxEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceConnectorProfileProperties model) {
            this.instanceUrl(model.instanceUrl);
            this.isSandboxEnvironment(model.isSandboxEnvironment);
        }

        public final String getInstanceUrl() {
            return this.instanceUrl;
        }

        @Override
        public final Builder instanceUrl(String instanceUrl) {
            this.instanceUrl = instanceUrl;
            return this;
        }

        public final void setInstanceUrl(String instanceUrl) {
            this.instanceUrl = instanceUrl;
        }

        public final Boolean getIsSandboxEnvironment() {
            return this.isSandboxEnvironment;
        }

        @Override
        public final Builder isSandboxEnvironment(Boolean isSandboxEnvironment) {
            this.isSandboxEnvironment = isSandboxEnvironment;
            return this;
        }

        public final void setIsSandboxEnvironment(Boolean isSandboxEnvironment) {
            this.isSandboxEnvironment = isSandboxEnvironment;
        }

        public SalesforceConnectorProfileProperties build() {
            return new SalesforceConnectorProfileProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SalesforceConnectorProfileProperties> {
        public Builder instanceUrl(String var1);

        public Builder isSandboxEnvironment(Boolean var1);
    }
}

