/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.ConnectorProfileNameListCopier;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectorProfilesRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, DescribeConnectorProfilesRequest> {
    private static final SdkField<List<String>> CONNECTOR_PROFILE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeConnectorProfilesRequest.getter(DescribeConnectorProfilesRequest::connectorProfileNames)).setter(DescribeConnectorProfilesRequest.setter(Builder::connectorProfileNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeConnectorProfilesRequest.getter(DescribeConnectorProfilesRequest::connectorTypeAsString)).setter(DescribeConnectorProfilesRequest.setter(Builder::connectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeConnectorProfilesRequest.getter(DescribeConnectorProfilesRequest::maxResults)).setter(DescribeConnectorProfilesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeConnectorProfilesRequest.getter(DescribeConnectorProfilesRequest::nextToken)).setter(DescribeConnectorProfilesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_NAMES_FIELD, CONNECTOR_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> connectorProfileNames;
    private final String connectorType;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeConnectorProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.connectorProfileNames = builder.connectorProfileNames;
        this.connectorType = builder.connectorType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public boolean hasConnectorProfileNames() {
        return this.connectorProfileNames != null && !(this.connectorProfileNames instanceof SdkAutoConstructList);
    }

    public List<String> connectorProfileNames() {
        return this.connectorProfileNames;
    }

    public ConnectorType connectorType() {
        return ConnectorType.fromValue(this.connectorType);
    }

    public String connectorTypeAsString() {
        return this.connectorType;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorProfilesRequest)) {
            return false;
        }
        DescribeConnectorProfilesRequest other = (DescribeConnectorProfilesRequest)((Object)obj);
        return Objects.equals(this.connectorProfileNames(), other.connectorProfileNames()) && Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConnectorProfilesRequest").add("ConnectorProfileNames", this.connectorProfileNames()).add("ConnectorType", (Object)this.connectorTypeAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorProfileNames": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileNames()));
            }
            case "connectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorProfilesRequest, T> g) {
        return obj -> g.apply((DescribeConnectorProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private List<String> connectorProfileNames = DefaultSdkAutoConstructList.getInstance();
        private String connectorType;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorProfilesRequest model) {
            super(model);
            this.connectorProfileNames(model.connectorProfileNames);
            this.connectorType(model.connectorType);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getConnectorProfileNames() {
            return this.connectorProfileNames;
        }

        @Override
        public final Builder connectorProfileNames(Collection<String> connectorProfileNames) {
            this.connectorProfileNames = ConnectorProfileNameListCopier.copy(connectorProfileNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorProfileNames(String ... connectorProfileNames) {
            this.connectorProfileNames(Arrays.asList(connectorProfileNames));
            return this;
        }

        public final void setConnectorProfileNames(Collection<String> connectorProfileNames) {
            this.connectorProfileNames = ConnectorProfileNameListCopier.copy(connectorProfileNames);
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConnectorProfilesRequest build() {
            return new DescribeConnectorProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectorProfilesRequest> {
        public Builder connectorProfileNames(Collection<String> var1);

        public Builder connectorProfileNames(String ... var1);

        public Builder connectorType(String var1);

        public Builder connectorType(ConnectorType var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

