/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthRequest> {
    private static final SdkField<String> REDIRECT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("redirectUri").getter(AuthRequest.getter(AuthRequest::redirectUri)).setter(AuthRequest.setter(Builder::redirectUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectUri").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(AuthRequest.getter(AuthRequest::code)).setter(AuthRequest.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDIRECT_URI_FIELD, CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String redirectUri;
    private final String code;

    private AuthRequest(BuilderImpl builder) {
        this.redirectUri = builder.redirectUri;
        this.code = builder.code;
    }

    public final String redirectUri() {
        return this.redirectUri;
    }

    public final String code() {
        return this.code;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthRequest)) {
            return false;
        }
        AuthRequest other = (AuthRequest)obj;
        return Objects.equals(this.redirectUri(), other.redirectUri()) && Objects.equals(this.code(), other.code());
    }

    public final String toString() {
        return ToString.builder((String)"AuthRequest").add("RedirectUri", (Object)this.redirectUri()).add("Code", (Object)(this.code() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "redirectUri": {
                return Optional.ofNullable(clazz.cast(this.redirectUri()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("redirectUri", REDIRECT_URI_FIELD);
        map.put("code", CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthRequest, T> g) {
        return obj -> g.apply((AuthRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String redirectUri;
        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthRequest model) {
            this.redirectUri(model.redirectUri);
            this.code(model.code);
        }

        public final String getRedirectUri() {
            return this.redirectUri;
        }

        public final void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public AuthRequest build() {
            return new AuthRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthRequest> {
        public Builder redirectUri(String var1);

        public Builder code(String var1);
    }
}

