/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Oauth2Credential
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Oauth2Credential> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(Oauth2Credential.getter(Oauth2Credential::clientId)).setter(Oauth2Credential.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientSecret").getter(Oauth2Credential.getter(Oauth2Credential::clientSecret)).setter(Oauth2Credential.setter(Builder::clientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, CLIENT_SECRET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Oauth2Credential.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientId;
    private final String clientSecret;

    private Oauth2Credential(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String clientSecret() {
        return this.clientSecret;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Oauth2Credential)) {
            return false;
        }
        Oauth2Credential other = (Oauth2Credential)obj;
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientSecret(), other.clientSecret());
    }

    public final String toString() {
        return ToString.builder((String)"Oauth2Credential").add("ClientId", (Object)this.clientId()).add("ClientSecret", (Object)(this.clientSecret() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "clientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("clientSecret", CLIENT_SECRET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Oauth2Credential, T> g) {
        return obj -> g.apply((Oauth2Credential)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientId;
        private String clientSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(Oauth2Credential model) {
            this.clientId(model.clientId);
            this.clientSecret(model.clientSecret);
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Oauth2Credential build() {
            return new Oauth2Credential(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Oauth2Credential> {
        public Builder clientId(String var1);

        public Builder clientSecret(String var1);
    }
}

