/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appfabric.model.AppFabricRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteIngestionDestinationRequest
extends AppFabricRequest
implements ToCopyableBuilder<Builder, DeleteIngestionDestinationRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appBundleIdentifier").getter(DeleteIngestionDestinationRequest.getter(DeleteIngestionDestinationRequest::appBundleIdentifier)).setter(DeleteIngestionDestinationRequest.setter(Builder::appBundleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appBundleIdentifier").build()}).build();
    private static final SdkField<String> INGESTION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestionIdentifier").getter(DeleteIngestionDestinationRequest.getter(DeleteIngestionDestinationRequest::ingestionIdentifier)).setter(DeleteIngestionDestinationRequest.setter(Builder::ingestionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ingestionIdentifier").build()}).build();
    private static final SdkField<String> INGESTION_DESTINATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestionDestinationIdentifier").getter(DeleteIngestionDestinationRequest.getter(DeleteIngestionDestinationRequest::ingestionDestinationIdentifier)).setter(DeleteIngestionDestinationRequest.setter(Builder::ingestionDestinationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ingestionDestinationIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD, INGESTION_IDENTIFIER_FIELD, INGESTION_DESTINATION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteIngestionDestinationRequest.memberNameToFieldInitializer();
    private final String appBundleIdentifier;
    private final String ingestionIdentifier;
    private final String ingestionDestinationIdentifier;

    private DeleteIngestionDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.ingestionIdentifier = builder.ingestionIdentifier;
        this.ingestionDestinationIdentifier = builder.ingestionDestinationIdentifier;
    }

    public final String appBundleIdentifier() {
        return this.appBundleIdentifier;
    }

    public final String ingestionIdentifier() {
        return this.ingestionIdentifier;
    }

    public final String ingestionDestinationIdentifier() {
        return this.ingestionDestinationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionDestinationIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIngestionDestinationRequest)) {
            return false;
        }
        DeleteIngestionDestinationRequest other = (DeleteIngestionDestinationRequest)((Object)obj);
        return Objects.equals(this.appBundleIdentifier(), other.appBundleIdentifier()) && Objects.equals(this.ingestionIdentifier(), other.ingestionIdentifier()) && Objects.equals(this.ingestionDestinationIdentifier(), other.ingestionDestinationIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteIngestionDestinationRequest").add("AppBundleIdentifier", (Object)this.appBundleIdentifier()).add("IngestionIdentifier", (Object)this.ingestionIdentifier()).add("IngestionDestinationIdentifier", (Object)this.ingestionDestinationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appBundleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.appBundleIdentifier()));
            }
            case "ingestionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.ingestionIdentifier()));
            }
            case "ingestionDestinationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.ingestionDestinationIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("appBundleIdentifier", APP_BUNDLE_IDENTIFIER_FIELD);
        map.put("ingestionIdentifier", INGESTION_IDENTIFIER_FIELD);
        map.put("ingestionDestinationIdentifier", INGESTION_DESTINATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteIngestionDestinationRequest, T> g) {
        return obj -> g.apply((DeleteIngestionDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppFabricRequest.BuilderImpl
    implements Builder {
        private String appBundleIdentifier;
        private String ingestionIdentifier;
        private String ingestionDestinationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIngestionDestinationRequest model) {
            super(model);
            this.appBundleIdentifier(model.appBundleIdentifier);
            this.ingestionIdentifier(model.ingestionIdentifier);
            this.ingestionDestinationIdentifier(model.ingestionDestinationIdentifier);
        }

        public final String getAppBundleIdentifier() {
            return this.appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final String getIngestionIdentifier() {
            return this.ingestionIdentifier;
        }

        public final void setIngestionIdentifier(String ingestionIdentifier) {
            this.ingestionIdentifier = ingestionIdentifier;
        }

        @Override
        public final Builder ingestionIdentifier(String ingestionIdentifier) {
            this.ingestionIdentifier = ingestionIdentifier;
            return this;
        }

        public final String getIngestionDestinationIdentifier() {
            return this.ingestionDestinationIdentifier;
        }

        public final void setIngestionDestinationIdentifier(String ingestionDestinationIdentifier) {
            this.ingestionDestinationIdentifier = ingestionDestinationIdentifier;
        }

        @Override
        public final Builder ingestionDestinationIdentifier(String ingestionDestinationIdentifier) {
            this.ingestionDestinationIdentifier = ingestionDestinationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteIngestionDestinationRequest build() {
            return new DeleteIngestionDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppFabricRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteIngestionDestinationRequest> {
        public Builder appBundleIdentifier(String var1);

        public Builder ingestionIdentifier(String var1);

        public Builder ingestionDestinationIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

