/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appfabric.model.ApiKeyCredential;
import software.amazon.awssdk.services.appfabric.model.Oauth2Credential;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Credential
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Credential> {
    private static final SdkField<Oauth2Credential> OAUTH2_CREDENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oauth2Credential").getter(Credential.getter(Credential::oauth2Credential)).setter(Credential.setter(Builder::oauth2Credential)).constructor(Oauth2Credential::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2Credential").build()}).build();
    private static final SdkField<ApiKeyCredential> API_KEY_CREDENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("apiKeyCredential").getter(Credential.getter(Credential::apiKeyCredential)).setter(Credential.setter(Builder::apiKeyCredential)).constructor(ApiKeyCredential::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyCredential").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OAUTH2_CREDENTIAL_FIELD, API_KEY_CREDENTIAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Credential.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Oauth2Credential oauth2Credential;
    private final ApiKeyCredential apiKeyCredential;
    private final Type type;

    private Credential(BuilderImpl builder) {
        this.oauth2Credential = builder.oauth2Credential;
        this.apiKeyCredential = builder.apiKeyCredential;
        this.type = builder.type;
    }

    public final Oauth2Credential oauth2Credential() {
        return this.oauth2Credential;
    }

    public final ApiKeyCredential apiKeyCredential() {
        return this.apiKeyCredential;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.oauth2Credential());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyCredential());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Credential)) {
            return false;
        }
        Credential other = (Credential)obj;
        return Objects.equals(this.oauth2Credential(), other.oauth2Credential()) && Objects.equals(this.apiKeyCredential(), other.apiKeyCredential());
    }

    public final String toString() {
        return ToString.builder((String)"Credential").add("Oauth2Credential", (Object)this.oauth2Credential()).add("ApiKeyCredential", (Object)this.apiKeyCredential()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "oauth2Credential": {
                return Optional.ofNullable(clazz.cast(this.oauth2Credential()));
            }
            case "apiKeyCredential": {
                return Optional.ofNullable(clazz.cast(this.apiKeyCredential()));
            }
        }
        return Optional.empty();
    }

    public static Credential fromOauth2Credential(Oauth2Credential oauth2Credential) {
        return (Credential)Credential.builder().oauth2Credential(oauth2Credential).build();
    }

    public static Credential fromOauth2Credential(Consumer<Oauth2Credential.Builder> oauth2Credential) {
        Oauth2Credential.Builder builder = Oauth2Credential.builder();
        oauth2Credential.accept(builder);
        return Credential.fromOauth2Credential((Oauth2Credential)builder.build());
    }

    public static Credential fromApiKeyCredential(ApiKeyCredential apiKeyCredential) {
        return (Credential)Credential.builder().apiKeyCredential(apiKeyCredential).build();
    }

    public static Credential fromApiKeyCredential(Consumer<ApiKeyCredential.Builder> apiKeyCredential) {
        ApiKeyCredential.Builder builder = ApiKeyCredential.builder();
        apiKeyCredential.accept(builder);
        return Credential.fromApiKeyCredential((ApiKeyCredential)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oauth2Credential", OAUTH2_CREDENTIAL_FIELD);
        map.put("apiKeyCredential", API_KEY_CREDENTIAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Credential, T> g) {
        return obj -> g.apply((Credential)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        OAUTH2_CREDENTIAL,
        API_KEY_CREDENTIAL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Oauth2Credential oauth2Credential;
        private ApiKeyCredential apiKeyCredential;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Credential model) {
            this.oauth2Credential(model.oauth2Credential);
            this.apiKeyCredential(model.apiKeyCredential);
        }

        public final Oauth2Credential.Builder getOauth2Credential() {
            return this.oauth2Credential != null ? this.oauth2Credential.toBuilder() : null;
        }

        public final void setOauth2Credential(Oauth2Credential.BuilderImpl oauth2Credential) {
            Oauth2Credential oldValue = this.oauth2Credential;
            this.oauth2Credential = oauth2Credential != null ? oauth2Credential.build() : null;
            this.handleUnionValueChange(Type.OAUTH2_CREDENTIAL, oldValue, this.oauth2Credential);
        }

        @Override
        public final Builder oauth2Credential(Oauth2Credential oauth2Credential) {
            Oauth2Credential oldValue = this.oauth2Credential;
            this.oauth2Credential = oauth2Credential;
            this.handleUnionValueChange(Type.OAUTH2_CREDENTIAL, oldValue, this.oauth2Credential);
            return this;
        }

        public final ApiKeyCredential.Builder getApiKeyCredential() {
            return this.apiKeyCredential != null ? this.apiKeyCredential.toBuilder() : null;
        }

        public final void setApiKeyCredential(ApiKeyCredential.BuilderImpl apiKeyCredential) {
            ApiKeyCredential oldValue = this.apiKeyCredential;
            this.apiKeyCredential = apiKeyCredential != null ? apiKeyCredential.build() : null;
            this.handleUnionValueChange(Type.API_KEY_CREDENTIAL, oldValue, this.apiKeyCredential);
        }

        @Override
        public final Builder apiKeyCredential(ApiKeyCredential apiKeyCredential) {
            ApiKeyCredential oldValue = this.apiKeyCredential;
            this.apiKeyCredential = apiKeyCredential;
            this.handleUnionValueChange(Type.API_KEY_CREDENTIAL, oldValue, this.apiKeyCredential);
            return this;
        }

        public Credential build() {
            return new Credential(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Credential> {
        public Builder oauth2Credential(Oauth2Credential var1);

        default public Builder oauth2Credential(Consumer<Oauth2Credential.Builder> oauth2Credential) {
            return this.oauth2Credential((Oauth2Credential)((Oauth2Credential.Builder)Oauth2Credential.builder().applyMutation(oauth2Credential)).build());
        }

        public Builder apiKeyCredential(ApiKeyCredential var1);

        default public Builder apiKeyCredential(Consumer<ApiKeyCredential.Builder> apiKeyCredential) {
            return this.apiKeyCredential((ApiKeyCredential)((ApiKeyCredential.Builder)ApiKeyCredential.builder().applyMutation(apiKeyCredential)).build());
        }
    }
}

