/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appfabric.model.AppAuthorizationStatus;
import software.amazon.awssdk.services.appfabric.model.AuthType;
import software.amazon.awssdk.services.appfabric.model.Persona;
import software.amazon.awssdk.services.appfabric.model.Tenant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppAuthorization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppAuthorization> {
    private static final SdkField<String> APP_AUTHORIZATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appAuthorizationArn").getter(AppAuthorization.getter(AppAuthorization::appAuthorizationArn)).setter(AppAuthorization.setter(Builder::appAuthorizationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appAuthorizationArn").build()}).build();
    private static final SdkField<String> APP_BUNDLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appBundleArn").getter(AppAuthorization.getter(AppAuthorization::appBundleArn)).setter(AppAuthorization.setter(Builder::appBundleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appBundleArn").build()}).build();
    private static final SdkField<String> APP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("app").getter(AppAuthorization.getter(AppAuthorization::app)).setter(AppAuthorization.setter(Builder::app)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("app").build()}).build();
    private static final SdkField<Tenant> TENANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tenant").getter(AppAuthorization.getter(AppAuthorization::tenant)).setter(AppAuthorization.setter(Builder::tenant)).constructor(Tenant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenant").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(AppAuthorization.getter(AppAuthorization::authTypeAsString)).setter(AppAuthorization.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AppAuthorization.getter(AppAuthorization::statusAsString)).setter(AppAuthorization.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AppAuthorization.getter(AppAuthorization::createdAt)).setter(AppAuthorization.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AppAuthorization.getter(AppAuthorization::updatedAt)).setter(AppAuthorization.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PERSONA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("persona").getter(AppAuthorization.getter(AppAuthorization::personaAsString)).setter(AppAuthorization.setter(Builder::persona)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("persona").build()}).build();
    private static final SdkField<String> AUTH_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authUrl").getter(AppAuthorization.getter(AppAuthorization::authUrl)).setter(AppAuthorization.setter(Builder::authUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_AUTHORIZATION_ARN_FIELD, APP_BUNDLE_ARN_FIELD, APP_FIELD, TENANT_FIELD, AUTH_TYPE_FIELD, STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, PERSONA_FIELD, AUTH_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppAuthorization.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appAuthorizationArn;
    private final String appBundleArn;
    private final String app;
    private final Tenant tenant;
    private final String authType;
    private final String status;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String persona;
    private final String authUrl;

    private AppAuthorization(BuilderImpl builder) {
        this.appAuthorizationArn = builder.appAuthorizationArn;
        this.appBundleArn = builder.appBundleArn;
        this.app = builder.app;
        this.tenant = builder.tenant;
        this.authType = builder.authType;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.persona = builder.persona;
        this.authUrl = builder.authUrl;
    }

    public final String appAuthorizationArn() {
        return this.appAuthorizationArn;
    }

    public final String appBundleArn() {
        return this.appBundleArn;
    }

    public final String app() {
        return this.app;
    }

    public final Tenant tenant() {
        return this.tenant;
    }

    public final AuthType authType() {
        return AuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final AppAuthorizationStatus status() {
        return AppAuthorizationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Persona persona() {
        return Persona.fromValue(this.persona);
    }

    public final String personaAsString() {
        return this.persona;
    }

    public final String authUrl() {
        return this.authUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appAuthorizationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appBundleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.app());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenant());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.personaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppAuthorization)) {
            return false;
        }
        AppAuthorization other = (AppAuthorization)obj;
        return Objects.equals(this.appAuthorizationArn(), other.appAuthorizationArn()) && Objects.equals(this.appBundleArn(), other.appBundleArn()) && Objects.equals(this.app(), other.app()) && Objects.equals(this.tenant(), other.tenant()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.personaAsString(), other.personaAsString()) && Objects.equals(this.authUrl(), other.authUrl());
    }

    public final String toString() {
        return ToString.builder((String)"AppAuthorization").add("AppAuthorizationArn", (Object)this.appAuthorizationArn()).add("AppBundleArn", (Object)this.appBundleArn()).add("App", (Object)this.app()).add("Tenant", (Object)this.tenant()).add("AuthType", (Object)this.authTypeAsString()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Persona", (Object)this.personaAsString()).add("AuthUrl", (Object)this.authUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appAuthorizationArn": {
                return Optional.ofNullable(clazz.cast(this.appAuthorizationArn()));
            }
            case "appBundleArn": {
                return Optional.ofNullable(clazz.cast(this.appBundleArn()));
            }
            case "app": {
                return Optional.ofNullable(clazz.cast(this.app()));
            }
            case "tenant": {
                return Optional.ofNullable(clazz.cast(this.tenant()));
            }
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "persona": {
                return Optional.ofNullable(clazz.cast(this.personaAsString()));
            }
            case "authUrl": {
                return Optional.ofNullable(clazz.cast(this.authUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appAuthorizationArn", APP_AUTHORIZATION_ARN_FIELD);
        map.put("appBundleArn", APP_BUNDLE_ARN_FIELD);
        map.put("app", APP_FIELD);
        map.put("tenant", TENANT_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("persona", PERSONA_FIELD);
        map.put("authUrl", AUTH_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppAuthorization, T> g) {
        return obj -> g.apply((AppAuthorization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appAuthorizationArn;
        private String appBundleArn;
        private String app;
        private Tenant tenant;
        private String authType;
        private String status;
        private Instant createdAt;
        private Instant updatedAt;
        private String persona;
        private String authUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(AppAuthorization model) {
            this.appAuthorizationArn(model.appAuthorizationArn);
            this.appBundleArn(model.appBundleArn);
            this.app(model.app);
            this.tenant(model.tenant);
            this.authType(model.authType);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.persona(model.persona);
            this.authUrl(model.authUrl);
        }

        public final String getAppAuthorizationArn() {
            return this.appAuthorizationArn;
        }

        public final void setAppAuthorizationArn(String appAuthorizationArn) {
            this.appAuthorizationArn = appAuthorizationArn;
        }

        @Override
        public final Builder appAuthorizationArn(String appAuthorizationArn) {
            this.appAuthorizationArn = appAuthorizationArn;
            return this;
        }

        public final String getAppBundleArn() {
            return this.appBundleArn;
        }

        public final void setAppBundleArn(String appBundleArn) {
            this.appBundleArn = appBundleArn;
        }

        @Override
        public final Builder appBundleArn(String appBundleArn) {
            this.appBundleArn = appBundleArn;
            return this;
        }

        public final String getApp() {
            return this.app;
        }

        public final void setApp(String app) {
            this.app = app;
        }

        @Override
        public final Builder app(String app) {
            this.app = app;
            return this;
        }

        public final Tenant.Builder getTenant() {
            return this.tenant != null ? this.tenant.toBuilder() : null;
        }

        public final void setTenant(Tenant.BuilderImpl tenant) {
            this.tenant = tenant != null ? tenant.build() : null;
        }

        @Override
        public final Builder tenant(Tenant tenant) {
            this.tenant = tenant;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppAuthorizationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getPersona() {
            return this.persona;
        }

        public final void setPersona(String persona) {
            this.persona = persona;
        }

        @Override
        public final Builder persona(String persona) {
            this.persona = persona;
            return this;
        }

        @Override
        public final Builder persona(Persona persona) {
            this.persona(persona == null ? null : persona.toString());
            return this;
        }

        public final String getAuthUrl() {
            return this.authUrl;
        }

        public final void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }

        @Override
        public final Builder authUrl(String authUrl) {
            this.authUrl = authUrl;
            return this;
        }

        public AppAuthorization build() {
            return new AppAuthorization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppAuthorization> {
        public Builder appAuthorizationArn(String var1);

        public Builder appBundleArn(String var1);

        public Builder app(String var1);

        public Builder tenant(Tenant var1);

        default public Builder tenant(Consumer<Tenant.Builder> tenant) {
            return this.tenant((Tenant)((Tenant.Builder)Tenant.builder().applyMutation(tenant)).build());
        }

        public Builder authType(String var1);

        public Builder authType(AuthType var1);

        public Builder status(String var1);

        public Builder status(AppAuthorizationStatus var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder persona(String var1);

        public Builder persona(Persona var1);

        public Builder authUrl(String var1);
    }
}

