/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appfabric.model.Format;
import software.amazon.awssdk.services.appfabric.model.Schema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditLogProcessingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditLogProcessingConfiguration> {
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schema").getter(AuditLogProcessingConfiguration.getter(AuditLogProcessingConfiguration::schemaAsString)).setter(AuditLogProcessingConfiguration.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(AuditLogProcessingConfiguration.getter(AuditLogProcessingConfiguration::formatAsString)).setter(AuditLogProcessingConfiguration.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FIELD, FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuditLogProcessingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String schema;
    private final String format;

    private AuditLogProcessingConfiguration(BuilderImpl builder) {
        this.schema = builder.schema;
        this.format = builder.format;
    }

    public final Schema schema() {
        return Schema.fromValue(this.schema);
    }

    public final String schemaAsString() {
        return this.schema;
    }

    public final Format format() {
        return Format.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditLogProcessingConfiguration)) {
            return false;
        }
        AuditLogProcessingConfiguration other = (AuditLogProcessingConfiguration)obj;
        return Objects.equals(this.schemaAsString(), other.schemaAsString()) && Objects.equals(this.formatAsString(), other.formatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AuditLogProcessingConfiguration").add("Schema", (Object)this.schemaAsString()).add("Format", (Object)this.formatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schemaAsString()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("schema", SCHEMA_FIELD);
        map.put("format", FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditLogProcessingConfiguration, T> g) {
        return obj -> g.apply((AuditLogProcessingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String schema;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditLogProcessingConfiguration model) {
            this.schema(model.schema);
            this.format(model.format);
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema(schema == null ? null : schema.toString());
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public AuditLogProcessingConfiguration build() {
            return new AuditLogProcessingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditLogProcessingConfiguration> {
        public Builder schema(String var1);

        public Builder schema(Schema var1);

        public Builder format(String var1);

        public Builder format(Format var1);
    }
}

