/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appfabric.model.AppAuthorizationStatus;
import software.amazon.awssdk.services.appfabric.model.Tenant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppAuthorizationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppAuthorizationSummary> {
    private static final SdkField<String> APP_AUTHORIZATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appAuthorizationArn").getter(AppAuthorizationSummary.getter(AppAuthorizationSummary::appAuthorizationArn)).setter(AppAuthorizationSummary.setter(Builder::appAuthorizationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appAuthorizationArn").build()}).build();
    private static final SdkField<String> APP_BUNDLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appBundleArn").getter(AppAuthorizationSummary.getter(AppAuthorizationSummary::appBundleArn)).setter(AppAuthorizationSummary.setter(Builder::appBundleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appBundleArn").build()}).build();
    private static final SdkField<String> APP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("app").getter(AppAuthorizationSummary.getter(AppAuthorizationSummary::app)).setter(AppAuthorizationSummary.setter(Builder::app)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("app").build()}).build();
    private static final SdkField<Tenant> TENANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tenant").getter(AppAuthorizationSummary.getter(AppAuthorizationSummary::tenant)).setter(AppAuthorizationSummary.setter(Builder::tenant)).constructor(Tenant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenant").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AppAuthorizationSummary.getter(AppAuthorizationSummary::statusAsString)).setter(AppAuthorizationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AppAuthorizationSummary.getter(AppAuthorizationSummary::updatedAt)).setter(AppAuthorizationSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_AUTHORIZATION_ARN_FIELD, APP_BUNDLE_ARN_FIELD, APP_FIELD, TENANT_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appAuthorizationArn", APP_AUTHORIZATION_ARN_FIELD);
            this.put("appBundleArn", APP_BUNDLE_ARN_FIELD);
            this.put("app", APP_FIELD);
            this.put("tenant", TENANT_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String appAuthorizationArn;
    private final String appBundleArn;
    private final String app;
    private final Tenant tenant;
    private final String status;
    private final Instant updatedAt;

    private AppAuthorizationSummary(BuilderImpl builder) {
        this.appAuthorizationArn = builder.appAuthorizationArn;
        this.appBundleArn = builder.appBundleArn;
        this.app = builder.app;
        this.tenant = builder.tenant;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public final String appAuthorizationArn() {
        return this.appAuthorizationArn;
    }

    public final String appBundleArn() {
        return this.appBundleArn;
    }

    public final String app() {
        return this.app;
    }

    public final Tenant tenant() {
        return this.tenant;
    }

    public final AppAuthorizationStatus status() {
        return AppAuthorizationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appAuthorizationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appBundleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.app());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenant());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppAuthorizationSummary)) {
            return false;
        }
        AppAuthorizationSummary other = (AppAuthorizationSummary)obj;
        return Objects.equals(this.appAuthorizationArn(), other.appAuthorizationArn()) && Objects.equals(this.appBundleArn(), other.appBundleArn()) && Objects.equals(this.app(), other.app()) && Objects.equals(this.tenant(), other.tenant()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"AppAuthorizationSummary").add("AppAuthorizationArn", (Object)this.appAuthorizationArn()).add("AppBundleArn", (Object)this.appBundleArn()).add("App", (Object)this.app()).add("Tenant", (Object)this.tenant()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appAuthorizationArn": {
                return Optional.ofNullable(clazz.cast(this.appAuthorizationArn()));
            }
            case "appBundleArn": {
                return Optional.ofNullable(clazz.cast(this.appBundleArn()));
            }
            case "app": {
                return Optional.ofNullable(clazz.cast(this.app()));
            }
            case "tenant": {
                return Optional.ofNullable(clazz.cast(this.tenant()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AppAuthorizationSummary, T> g) {
        return obj -> g.apply((AppAuthorizationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appAuthorizationArn;
        private String appBundleArn;
        private String app;
        private Tenant tenant;
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AppAuthorizationSummary model) {
            this.appAuthorizationArn(model.appAuthorizationArn);
            this.appBundleArn(model.appBundleArn);
            this.app(model.app);
            this.tenant(model.tenant);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final String getAppAuthorizationArn() {
            return this.appAuthorizationArn;
        }

        public final void setAppAuthorizationArn(String appAuthorizationArn) {
            this.appAuthorizationArn = appAuthorizationArn;
        }

        @Override
        public final Builder appAuthorizationArn(String appAuthorizationArn) {
            this.appAuthorizationArn = appAuthorizationArn;
            return this;
        }

        public final String getAppBundleArn() {
            return this.appBundleArn;
        }

        public final void setAppBundleArn(String appBundleArn) {
            this.appBundleArn = appBundleArn;
        }

        @Override
        public final Builder appBundleArn(String appBundleArn) {
            this.appBundleArn = appBundleArn;
            return this;
        }

        public final String getApp() {
            return this.app;
        }

        public final void setApp(String app) {
            this.app = app;
        }

        @Override
        public final Builder app(String app) {
            this.app = app;
            return this;
        }

        public final Tenant.Builder getTenant() {
            return this.tenant != null ? this.tenant.toBuilder() : null;
        }

        public final void setTenant(Tenant.BuilderImpl tenant) {
            this.tenant = tenant != null ? tenant.build() : null;
        }

        @Override
        public final Builder tenant(Tenant tenant) {
            this.tenant = tenant;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppAuthorizationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public AppAuthorizationSummary build() {
            return new AppAuthorizationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppAuthorizationSummary> {
        public Builder appAuthorizationArn(String var1);

        public Builder appBundleArn(String var1);

        public Builder app(String var1);

        public Builder tenant(Tenant var1);

        default public Builder tenant(Consumer<Tenant.Builder> tenant) {
            return this.tenant((Tenant)((Tenant.Builder)Tenant.builder().applyMutation(tenant)).build());
        }

        public Builder status(String var1);

        public Builder status(AppAuthorizationStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

