/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Schema {
    OCSF("ocsf"),
    RAW("raw"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Schema> VALUE_MAP;
    private final String value;

    private Schema(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Schema fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Schema> knownValues() {
        EnumSet<Schema> knownValues = EnumSet.allOf(Schema.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Schema.class, Schema::toString);
    }
}

