/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appfabric.model.AppFabricRequest;
import software.amazon.awssdk.services.appfabric.model.AuthRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectAppAuthorizationRequest
extends AppFabricRequest
implements ToCopyableBuilder<Builder, ConnectAppAuthorizationRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appBundleIdentifier").getter(ConnectAppAuthorizationRequest.getter(ConnectAppAuthorizationRequest::appBundleIdentifier)).setter(ConnectAppAuthorizationRequest.setter(Builder::appBundleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appBundleIdentifier").build()}).build();
    private static final SdkField<String> APP_AUTHORIZATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appAuthorizationIdentifier").getter(ConnectAppAuthorizationRequest.getter(ConnectAppAuthorizationRequest::appAuthorizationIdentifier)).setter(ConnectAppAuthorizationRequest.setter(Builder::appAuthorizationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appAuthorizationIdentifier").build()}).build();
    private static final SdkField<AuthRequest> AUTH_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authRequest").getter(ConnectAppAuthorizationRequest.getter(ConnectAppAuthorizationRequest::authRequest)).setter(ConnectAppAuthorizationRequest.setter(Builder::authRequest)).constructor(AuthRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authRequest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD, APP_AUTHORIZATION_IDENTIFIER_FIELD, AUTH_REQUEST_FIELD));
    private final String appBundleIdentifier;
    private final String appAuthorizationIdentifier;
    private final AuthRequest authRequest;

    private ConnectAppAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.appAuthorizationIdentifier = builder.appAuthorizationIdentifier;
        this.authRequest = builder.authRequest;
    }

    public final String appBundleIdentifier() {
        return this.appBundleIdentifier;
    }

    public final String appAuthorizationIdentifier() {
        return this.appAuthorizationIdentifier;
    }

    public final AuthRequest authRequest() {
        return this.authRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.appAuthorizationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.authRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectAppAuthorizationRequest)) {
            return false;
        }
        ConnectAppAuthorizationRequest other = (ConnectAppAuthorizationRequest)((Object)obj);
        return Objects.equals(this.appBundleIdentifier(), other.appBundleIdentifier()) && Objects.equals(this.appAuthorizationIdentifier(), other.appAuthorizationIdentifier()) && Objects.equals(this.authRequest(), other.authRequest());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectAppAuthorizationRequest").add("AppBundleIdentifier", (Object)this.appBundleIdentifier()).add("AppAuthorizationIdentifier", (Object)this.appAuthorizationIdentifier()).add("AuthRequest", (Object)this.authRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appBundleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.appBundleIdentifier()));
            }
            case "appAuthorizationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.appAuthorizationIdentifier()));
            }
            case "authRequest": {
                return Optional.ofNullable(clazz.cast(this.authRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectAppAuthorizationRequest, T> g) {
        return obj -> g.apply((ConnectAppAuthorizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppFabricRequest.BuilderImpl
    implements Builder {
        private String appBundleIdentifier;
        private String appAuthorizationIdentifier;
        private AuthRequest authRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectAppAuthorizationRequest model) {
            super(model);
            this.appBundleIdentifier(model.appBundleIdentifier);
            this.appAuthorizationIdentifier(model.appAuthorizationIdentifier);
            this.authRequest(model.authRequest);
        }

        public final String getAppBundleIdentifier() {
            return this.appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final String getAppAuthorizationIdentifier() {
            return this.appAuthorizationIdentifier;
        }

        public final void setAppAuthorizationIdentifier(String appAuthorizationIdentifier) {
            this.appAuthorizationIdentifier = appAuthorizationIdentifier;
        }

        @Override
        public final Builder appAuthorizationIdentifier(String appAuthorizationIdentifier) {
            this.appAuthorizationIdentifier = appAuthorizationIdentifier;
            return this;
        }

        public final AuthRequest.Builder getAuthRequest() {
            return this.authRequest != null ? this.authRequest.toBuilder() : null;
        }

        public final void setAuthRequest(AuthRequest.BuilderImpl authRequest) {
            this.authRequest = authRequest != null ? authRequest.build() : null;
        }

        @Override
        public final Builder authRequest(AuthRequest authRequest) {
            this.authRequest = authRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConnectAppAuthorizationRequest build() {
            return new ConnectAppAuthorizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppFabricRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConnectAppAuthorizationRequest> {
        public Builder appBundleIdentifier(String var1);

        public Builder appAuthorizationIdentifier(String var1);

        public Builder authRequest(AuthRequest var1);

        default public Builder authRequest(Consumer<AuthRequest.Builder> authRequest) {
            return this.authRequest((AuthRequest)((AuthRequest.Builder)AuthRequest.builder().applyMutation(authRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

