/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appfabric.AppFabricClient;
import software.amazon.awssdk.services.appfabric.model.IngestionSummary;
import software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest;
import software.amazon.awssdk.services.appfabric.model.ListIngestionsResponse;

public class ListIngestionsIterable
implements SdkIterable<ListIngestionsResponse> {
    private final AppFabricClient client;
    private final ListIngestionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIngestionsIterable(AppFabricClient client, ListIngestionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIngestionsResponseFetcher();
    }

    public Iterator<ListIngestionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IngestionSummary> ingestions() {
        Function<ListIngestionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ingestions() != null) {
                return response.ingestions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIngestionsResponseFetcher
    implements SyncPageFetcher<ListIngestionsResponse> {
        private ListIngestionsResponseFetcher() {
        }

        public boolean hasNextPage(ListIngestionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIngestionsResponse nextPage(ListIngestionsResponse previousPage) {
            if (previousPage == null) {
                return ListIngestionsIterable.this.client.listIngestions(ListIngestionsIterable.this.firstRequest);
            }
            return ListIngestionsIterable.this.client.listIngestions((ListIngestionsRequest)((Object)ListIngestionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

