/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appfabric.AppFabricClient;
import software.amazon.awssdk.services.appfabric.AppFabricClientBuilder;
import software.amazon.awssdk.services.appfabric.AppFabricServiceClientConfiguration;
import software.amazon.awssdk.services.appfabric.DefaultAppFabricBaseClientBuilder;
import software.amazon.awssdk.services.appfabric.DefaultAppFabricClient;
import software.amazon.awssdk.services.appfabric.endpoints.AppFabricEndpointProvider;

@SdkInternalApi
final class DefaultAppFabricClientBuilder
extends DefaultAppFabricBaseClientBuilder<AppFabricClientBuilder, AppFabricClient>
implements AppFabricClientBuilder {
    DefaultAppFabricClientBuilder() {
    }

    @Override
    public DefaultAppFabricClientBuilder endpointProvider(AppFabricEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppFabricClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAppFabricClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        AppFabricServiceClientConfiguration serviceClientConfiguration = AppFabricServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultAppFabricClient(serviceClientConfiguration, clientConfiguration);
    }
}

