/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfigdata.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfigdata.model.AppConfigDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLatestConfigurationResponse
extends AppConfigDataResponse
implements ToCopyableBuilder<Builder, GetLatestConfigurationResponse> {
    private static final SdkField<String> NEXT_POLL_CONFIGURATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPollConfigurationToken").getter(GetLatestConfigurationResponse.getter(GetLatestConfigurationResponse::nextPollConfigurationToken)).setter(GetLatestConfigurationResponse.setter(Builder::nextPollConfigurationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Next-Poll-Configuration-Token").build()}).build();
    private static final SdkField<Integer> NEXT_POLL_INTERVAL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NextPollIntervalInSeconds").getter(GetLatestConfigurationResponse.getter(GetLatestConfigurationResponse::nextPollIntervalInSeconds)).setter(GetLatestConfigurationResponse.setter(Builder::nextPollIntervalInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Next-Poll-Interval-In-Seconds").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(GetLatestConfigurationResponse.getter(GetLatestConfigurationResponse::contentType)).setter(GetLatestConfigurationResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<SdkBytes> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Configuration").getter(GetLatestConfigurationResponse.getter(GetLatestConfigurationResponse::configuration)).setter(GetLatestConfigurationResponse.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionLabel").getter(GetLatestConfigurationResponse.getter(GetLatestConfigurationResponse::versionLabel)).setter(GetLatestConfigurationResponse.setter(Builder::versionLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Version-Label").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_POLL_CONFIGURATION_TOKEN_FIELD, NEXT_POLL_INTERVAL_IN_SECONDS_FIELD, CONTENT_TYPE_FIELD, CONFIGURATION_FIELD, VERSION_LABEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Next-Poll-Configuration-Token", NEXT_POLL_CONFIGURATION_TOKEN_FIELD);
            this.put("Next-Poll-Interval-In-Seconds", NEXT_POLL_INTERVAL_IN_SECONDS_FIELD);
            this.put("Content-Type", CONTENT_TYPE_FIELD);
            this.put("Configuration", CONFIGURATION_FIELD);
            this.put("Version-Label", VERSION_LABEL_FIELD);
        }
    });
    private final String nextPollConfigurationToken;
    private final Integer nextPollIntervalInSeconds;
    private final String contentType;
    private final SdkBytes configuration;
    private final String versionLabel;

    private GetLatestConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.nextPollConfigurationToken = builder.nextPollConfigurationToken;
        this.nextPollIntervalInSeconds = builder.nextPollIntervalInSeconds;
        this.contentType = builder.contentType;
        this.configuration = builder.configuration;
        this.versionLabel = builder.versionLabel;
    }

    public final String nextPollConfigurationToken() {
        return this.nextPollConfigurationToken;
    }

    public final Integer nextPollIntervalInSeconds() {
        return this.nextPollIntervalInSeconds;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final SdkBytes configuration() {
        return this.configuration;
    }

    public final String versionLabel() {
        return this.versionLabel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPollConfigurationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPollIntervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLatestConfigurationResponse)) {
            return false;
        }
        GetLatestConfigurationResponse other = (GetLatestConfigurationResponse)((Object)obj);
        return Objects.equals(this.nextPollConfigurationToken(), other.nextPollConfigurationToken()) && Objects.equals(this.nextPollIntervalInSeconds(), other.nextPollIntervalInSeconds()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.versionLabel(), other.versionLabel());
    }

    public final String toString() {
        return ToString.builder((String)"GetLatestConfigurationResponse").add("NextPollConfigurationToken", (Object)this.nextPollConfigurationToken()).add("NextPollIntervalInSeconds", (Object)this.nextPollIntervalInSeconds()).add("ContentType", (Object)this.contentType()).add("Configuration", (Object)(this.configuration() == null ? null : "*** Sensitive Data Redacted ***")).add("VersionLabel", (Object)this.versionLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextPollConfigurationToken": {
                return Optional.ofNullable(clazz.cast(this.nextPollConfigurationToken()));
            }
            case "NextPollIntervalInSeconds": {
                return Optional.ofNullable(clazz.cast(this.nextPollIntervalInSeconds()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "VersionLabel": {
                return Optional.ofNullable(clazz.cast(this.versionLabel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLatestConfigurationResponse, T> g) {
        return obj -> g.apply((GetLatestConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigDataResponse.BuilderImpl
    implements Builder {
        private String nextPollConfigurationToken;
        private Integer nextPollIntervalInSeconds;
        private String contentType;
        private SdkBytes configuration;
        private String versionLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLatestConfigurationResponse model) {
            super(model);
            this.nextPollConfigurationToken(model.nextPollConfigurationToken);
            this.nextPollIntervalInSeconds(model.nextPollIntervalInSeconds);
            this.contentType(model.contentType);
            this.configuration(model.configuration);
            this.versionLabel(model.versionLabel);
        }

        public final String getNextPollConfigurationToken() {
            return this.nextPollConfigurationToken;
        }

        public final void setNextPollConfigurationToken(String nextPollConfigurationToken) {
            this.nextPollConfigurationToken = nextPollConfigurationToken;
        }

        @Override
        public final Builder nextPollConfigurationToken(String nextPollConfigurationToken) {
            this.nextPollConfigurationToken = nextPollConfigurationToken;
            return this;
        }

        public final Integer getNextPollIntervalInSeconds() {
            return this.nextPollIntervalInSeconds;
        }

        public final void setNextPollIntervalInSeconds(Integer nextPollIntervalInSeconds) {
            this.nextPollIntervalInSeconds = nextPollIntervalInSeconds;
        }

        @Override
        public final Builder nextPollIntervalInSeconds(Integer nextPollIntervalInSeconds) {
            this.nextPollIntervalInSeconds = nextPollIntervalInSeconds;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final ByteBuffer getConfiguration() {
            return this.configuration == null ? null : this.configuration.asByteBuffer();
        }

        public final void setConfiguration(ByteBuffer configuration) {
            this.configuration(configuration == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)configuration));
        }

        @Override
        public final Builder configuration(SdkBytes configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        @Override
        public GetLatestConfigurationResponse build() {
            return new GetLatestConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppConfigDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLatestConfigurationResponse> {
        public Builder nextPollConfigurationToken(String var1);

        public Builder nextPollIntervalInSeconds(Integer var1);

        public Builder contentType(String var1);

        public Builder configuration(SdkBytes var1);

        public Builder versionLabel(String var1);
    }
}

