/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfigdata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfigdata.model.AppConfigDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartConfigurationSessionRequest
extends AppConfigDataRequest
implements ToCopyableBuilder<Builder, StartConfigurationSessionRequest> {
    private static final SdkField<String> APPLICATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationIdentifier").getter(StartConfigurationSessionRequest.getter(StartConfigurationSessionRequest::applicationIdentifier)).setter(StartConfigurationSessionRequest.setter(Builder::applicationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIdentifier").build()}).build();
    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentIdentifier").getter(StartConfigurationSessionRequest.getter(StartConfigurationSessionRequest::environmentIdentifier)).setter(StartConfigurationSessionRequest.setter(Builder::environmentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentIdentifier").build()}).build();
    private static final SdkField<String> CONFIGURATION_PROFILE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationProfileIdentifier").getter(StartConfigurationSessionRequest.getter(StartConfigurationSessionRequest::configurationProfileIdentifier)).setter(StartConfigurationSessionRequest.setter(Builder::configurationProfileIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationProfileIdentifier").build()}).build();
    private static final SdkField<Integer> REQUIRED_MINIMUM_POLL_INTERVAL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RequiredMinimumPollIntervalInSeconds").getter(StartConfigurationSessionRequest.getter(StartConfigurationSessionRequest::requiredMinimumPollIntervalInSeconds)).setter(StartConfigurationSessionRequest.setter(Builder::requiredMinimumPollIntervalInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredMinimumPollIntervalInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_IDENTIFIER_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, CONFIGURATION_PROFILE_IDENTIFIER_FIELD, REQUIRED_MINIMUM_POLL_INTERVAL_IN_SECONDS_FIELD));
    private final String applicationIdentifier;
    private final String environmentIdentifier;
    private final String configurationProfileIdentifier;
    private final Integer requiredMinimumPollIntervalInSeconds;

    private StartConfigurationSessionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationIdentifier = builder.applicationIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.configurationProfileIdentifier = builder.configurationProfileIdentifier;
        this.requiredMinimumPollIntervalInSeconds = builder.requiredMinimumPollIntervalInSeconds;
    }

    public final String applicationIdentifier() {
        return this.applicationIdentifier;
    }

    public final String environmentIdentifier() {
        return this.environmentIdentifier;
    }

    public final String configurationProfileIdentifier() {
        return this.configurationProfileIdentifier;
    }

    public final Integer requiredMinimumPollIntervalInSeconds() {
        return this.requiredMinimumPollIntervalInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationProfileIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiredMinimumPollIntervalInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConfigurationSessionRequest)) {
            return false;
        }
        StartConfigurationSessionRequest other = (StartConfigurationSessionRequest)((Object)obj);
        return Objects.equals(this.applicationIdentifier(), other.applicationIdentifier()) && Objects.equals(this.environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(this.configurationProfileIdentifier(), other.configurationProfileIdentifier()) && Objects.equals(this.requiredMinimumPollIntervalInSeconds(), other.requiredMinimumPollIntervalInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"StartConfigurationSessionRequest").add("ApplicationIdentifier", (Object)this.applicationIdentifier()).add("EnvironmentIdentifier", (Object)this.environmentIdentifier()).add("ConfigurationProfileIdentifier", (Object)this.configurationProfileIdentifier()).add("RequiredMinimumPollIntervalInSeconds", (Object)this.requiredMinimumPollIntervalInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.applicationIdentifier()));
            }
            case "EnvironmentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentIdentifier()));
            }
            case "ConfigurationProfileIdentifier": {
                return Optional.ofNullable(clazz.cast(this.configurationProfileIdentifier()));
            }
            case "RequiredMinimumPollIntervalInSeconds": {
                return Optional.ofNullable(clazz.cast(this.requiredMinimumPollIntervalInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartConfigurationSessionRequest, T> g) {
        return obj -> g.apply((StartConfigurationSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigDataRequest.BuilderImpl
    implements Builder {
        private String applicationIdentifier;
        private String environmentIdentifier;
        private String configurationProfileIdentifier;
        private Integer requiredMinimumPollIntervalInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConfigurationSessionRequest model) {
            super(model);
            this.applicationIdentifier(model.applicationIdentifier);
            this.environmentIdentifier(model.environmentIdentifier);
            this.configurationProfileIdentifier(model.configurationProfileIdentifier);
            this.requiredMinimumPollIntervalInSeconds(model.requiredMinimumPollIntervalInSeconds);
        }

        public final String getApplicationIdentifier() {
            return this.applicationIdentifier;
        }

        public final void setApplicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
        }

        @Override
        @Transient
        public final Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        @Transient
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getConfigurationProfileIdentifier() {
            return this.configurationProfileIdentifier;
        }

        public final void setConfigurationProfileIdentifier(String configurationProfileIdentifier) {
            this.configurationProfileIdentifier = configurationProfileIdentifier;
        }

        @Override
        @Transient
        public final Builder configurationProfileIdentifier(String configurationProfileIdentifier) {
            this.configurationProfileIdentifier = configurationProfileIdentifier;
            return this;
        }

        public final Integer getRequiredMinimumPollIntervalInSeconds() {
            return this.requiredMinimumPollIntervalInSeconds;
        }

        public final void setRequiredMinimumPollIntervalInSeconds(Integer requiredMinimumPollIntervalInSeconds) {
            this.requiredMinimumPollIntervalInSeconds = requiredMinimumPollIntervalInSeconds;
        }

        @Override
        @Transient
        public final Builder requiredMinimumPollIntervalInSeconds(Integer requiredMinimumPollIntervalInSeconds) {
            this.requiredMinimumPollIntervalInSeconds = requiredMinimumPollIntervalInSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartConfigurationSessionRequest build() {
            return new StartConfigurationSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppConfigDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartConfigurationSessionRequest> {
        public Builder applicationIdentifier(String var1);

        public Builder environmentIdentifier(String var1);

        public Builder configurationProfileIdentifier(String var1);

        public Builder requiredMinimumPollIntervalInSeconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

