/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDeploymentRequest extends AppConfigRequest implements
        ToCopyableBuilder<StartDeploymentRequest.Builder, StartDeploymentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(StartDeploymentRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(StartDeploymentRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentId").build()).build();

    private static final SdkField<String> DEPLOYMENT_STRATEGY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStrategyId").getter(getter(StartDeploymentRequest::deploymentStrategyId))
            .setter(setter(Builder::deploymentStrategyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStrategyId").build())
            .build();

    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationProfileId").getter(getter(StartDeploymentRequest::configurationProfileId))
            .setter(setter(Builder::configurationProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationProfileId").build())
            .build();

    private static final SdkField<String> CONFIGURATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationVersion").getter(getter(StartDeploymentRequest::configurationVersion))
            .setter(setter(Builder::configurationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationVersion").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartDeploymentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(StartDeploymentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyIdentifier").getter(getter(StartDeploymentRequest::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()).build();

    private static final SdkField<Map<String, String>> DYNAMIC_EXTENSION_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DynamicExtensionParameters")
            .getter(getter(StartDeploymentRequest::dynamicExtensionParameters))
            .setter(setter(Builder::dynamicExtensionParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicExtensionParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ENVIRONMENT_ID_FIELD, DEPLOYMENT_STRATEGY_ID_FIELD, CONFIGURATION_PROFILE_ID_FIELD, CONFIGURATION_VERSION_FIELD,
            DESCRIPTION_FIELD, TAGS_FIELD, KMS_KEY_IDENTIFIER_FIELD, DYNAMIC_EXTENSION_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String environmentId;

    private final String deploymentStrategyId;

    private final String configurationProfileId;

    private final String configurationVersion;

    private final String description;

    private final Map<String, String> tags;

    private final String kmsKeyIdentifier;

    private final Map<String, String> dynamicExtensionParameters;

    private StartDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.environmentId = builder.environmentId;
        this.deploymentStrategyId = builder.deploymentStrategyId;
        this.configurationProfileId = builder.configurationProfileId;
        this.configurationVersion = builder.configurationVersion;
        this.description = builder.description;
        this.tags = builder.tags;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.dynamicExtensionParameters = builder.dynamicExtensionParameters;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The environment ID.
     * </p>
     * 
     * @return The environment ID.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The deployment strategy ID.
     * </p>
     * 
     * @return The deployment strategy ID.
     */
    public final String deploymentStrategyId() {
        return deploymentStrategyId;
    }

    /**
     * <p>
     * The configuration profile ID.
     * </p>
     * 
     * @return The configuration profile ID.
     */
    public final String configurationProfileId() {
        return configurationProfileId;
    }

    /**
     * <p>
     * The configuration version to deploy. If deploying an AppConfig hosted configuration version, you can specify
     * either the version number or version label. For all other configurations, you must specify the version number.
     * </p>
     * 
     * @return The configuration version to deploy. If deploying an AppConfig hosted configuration version, you can
     *         specify either the version number or version label. For all other configurations, you must specify the
     *         version number.
     */
    public final String configurationVersion() {
        return configurationVersion;
    }

    /**
     * <p>
     * A description of the deployment.
     * </p>
     * 
     * @return A description of the deployment.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag
     * consists of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each
     *         tag consists of a key and an optional value, both of which you define.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The KMS key identifier (key ID, key alias, or key ARN). AppConfig uses this ID to encrypt the configuration data
     * using a customer managed key.
     * </p>
     * 
     * @return The KMS key identifier (key ID, key alias, or key ARN). AppConfig uses this ID to encrypt the
     *         configuration data using a customer managed key.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the DynamicExtensionParameters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDynamicExtensionParameters() {
        return dynamicExtensionParameters != null && !(dynamicExtensionParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of dynamic extension parameter names to values to pass to associated extensions with
     * <code>PRE_START_DEPLOYMENT</code> actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDynamicExtensionParameters} method.
     * </p>
     * 
     * @return A map of dynamic extension parameter names to values to pass to associated extensions with
     *         <code>PRE_START_DEPLOYMENT</code> actions.
     */
    public final Map<String, String> dynamicExtensionParameters() {
        return dynamicExtensionParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasDynamicExtensionParameters() ? dynamicExtensionParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeploymentRequest)) {
            return false;
        }
        StartDeploymentRequest other = (StartDeploymentRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(deploymentStrategyId(), other.deploymentStrategyId())
                && Objects.equals(configurationProfileId(), other.configurationProfileId())
                && Objects.equals(configurationVersion(), other.configurationVersion())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier())
                && hasDynamicExtensionParameters() == other.hasDynamicExtensionParameters()
                && Objects.equals(dynamicExtensionParameters(), other.dynamicExtensionParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("StartDeploymentRequest")
                .add("ApplicationId", applicationId())
                .add("EnvironmentId", environmentId())
                .add("DeploymentStrategyId", deploymentStrategyId())
                .add("ConfigurationProfileId", configurationProfileId())
                .add("ConfigurationVersion", configurationVersion())
                .add("Description", description())
                .add("Tags", hasTags() ? tags() : null)
                .add("KmsKeyIdentifier", kmsKeyIdentifier())
                .add("DynamicExtensionParameters",
                        dynamicExtensionParameters() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "DeploymentStrategyId":
            return Optional.ofNullable(clazz.cast(deploymentStrategyId()));
        case "ConfigurationProfileId":
            return Optional.ofNullable(clazz.cast(configurationProfileId()));
        case "ConfigurationVersion":
            return Optional.ofNullable(clazz.cast(configurationVersion()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "DynamicExtensionParameters":
            return Optional.ofNullable(clazz.cast(dynamicExtensionParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("DeploymentStrategyId", DEPLOYMENT_STRATEGY_ID_FIELD);
        map.put("ConfigurationProfileId", CONFIGURATION_PROFILE_ID_FIELD);
        map.put("ConfigurationVersion", CONFIGURATION_VERSION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("DynamicExtensionParameters", DYNAMIC_EXTENSION_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDeploymentRequest, T> g) {
        return obj -> g.apply((StartDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartDeploymentRequest> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The environment ID.
         * </p>
         * 
         * @param environmentId
         *        The environment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The deployment strategy ID.
         * </p>
         * 
         * @param deploymentStrategyId
         *        The deployment strategy ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStrategyId(String deploymentStrategyId);

        /**
         * <p>
         * The configuration profile ID.
         * </p>
         * 
         * @param configurationProfileId
         *        The configuration profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProfileId(String configurationProfileId);

        /**
         * <p>
         * The configuration version to deploy. If deploying an AppConfig hosted configuration version, you can specify
         * either the version number or version label. For all other configurations, you must specify the version
         * number.
         * </p>
         * 
         * @param configurationVersion
         *        The configuration version to deploy. If deploying an AppConfig hosted configuration version, you can
         *        specify either the version number or version label. For all other configurations, you must specify the
         *        version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationVersion(String configurationVersion);

        /**
         * <p>
         * A description of the deployment.
         * </p>
         * 
         * @param description
         *        A description of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * 
         * @param tags
         *        Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each
         *        tag consists of a key and an optional value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The KMS key identifier (key ID, key alias, or key ARN). AppConfig uses this ID to encrypt the configuration
         * data using a customer managed key.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        The KMS key identifier (key ID, key alias, or key ARN). AppConfig uses this ID to encrypt the
         *        configuration data using a customer managed key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * <p>
         * A map of dynamic extension parameter names to values to pass to associated extensions with
         * <code>PRE_START_DEPLOYMENT</code> actions.
         * </p>
         * 
         * @param dynamicExtensionParameters
         *        A map of dynamic extension parameter names to values to pass to associated extensions with
         *        <code>PRE_START_DEPLOYMENT</code> actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicExtensionParameters(Map<String, String> dynamicExtensionParameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String environmentId;

        private String deploymentStrategyId;

        private String configurationProfileId;

        private String configurationVersion;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String kmsKeyIdentifier;

        private Map<String, String> dynamicExtensionParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeploymentRequest model) {
            super(model);
            applicationId(model.applicationId);
            environmentId(model.environmentId);
            deploymentStrategyId(model.deploymentStrategyId);
            configurationProfileId(model.configurationProfileId);
            configurationVersion(model.configurationVersion);
            description(model.description);
            tags(model.tags);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            dynamicExtensionParameters(model.dynamicExtensionParameters);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDeploymentStrategyId() {
            return deploymentStrategyId;
        }

        public final void setDeploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
        }

        @Override
        public final Builder deploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
            return this;
        }

        public final String getConfigurationProfileId() {
            return configurationProfileId;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final String getConfigurationVersion() {
            return configurationVersion;
        }

        public final void setConfigurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
        }

        @Override
        public final Builder configurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final Map<String, String> getDynamicExtensionParameters() {
            if (dynamicExtensionParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return dynamicExtensionParameters;
        }

        public final void setDynamicExtensionParameters(Map<String, String> dynamicExtensionParameters) {
            this.dynamicExtensionParameters = DynamicParameterMapCopier.copy(dynamicExtensionParameters);
        }

        @Override
        public final Builder dynamicExtensionParameters(Map<String, String> dynamicExtensionParameters) {
            this.dynamicExtensionParameters = DynamicParameterMapCopier.copy(dynamicExtensionParameters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeploymentRequest build() {
            return new StartDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
