/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateExtensionAssociationResponse extends AppConfigResponse implements
        ToCopyableBuilder<UpdateExtensionAssociationResponse.Builder, UpdateExtensionAssociationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateExtensionAssociationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> EXTENSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtensionArn").getter(getter(UpdateExtensionAssociationResponse::extensionArn))
            .setter(setter(Builder::extensionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionArn").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(UpdateExtensionAssociationResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateExtensionAssociationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(UpdateExtensionAssociationResponse::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> EXTENSION_VERSION_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExtensionVersionNumber").getter(getter(UpdateExtensionAssociationResponse::extensionVersionNumber))
            .setter(setter(Builder::extensionVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXTENSION_ARN_FIELD,
            RESOURCE_ARN_FIELD, ARN_FIELD, PARAMETERS_FIELD, EXTENSION_VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String extensionArn;

    private final String resourceArn;

    private final String arn;

    private final Map<String, String> parameters;

    private final Integer extensionVersionNumber;

    private UpdateExtensionAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.extensionArn = builder.extensionArn;
        this.resourceArn = builder.resourceArn;
        this.arn = builder.arn;
        this.parameters = builder.parameters;
        this.extensionVersionNumber = builder.extensionVersionNumber;
    }

    /**
     * <p>
     * The system-generated ID for the association.
     * </p>
     * 
     * @return The system-generated ID for the association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the extension defined in the association.
     * </p>
     * 
     * @return The ARN of the extension defined in the association.
     */
    public final String extensionArn() {
        return extensionArn;
    }

    /**
     * <p>
     * The ARNs of applications, configuration profiles, or environments defined in the association.
     * </p>
     * 
     * @return The ARNs of applications, configuration profiles, or environments defined in the association.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The system-generated Amazon Resource Name (ARN) for the extension.
     * </p>
     * 
     * @return The system-generated Amazon Resource Name (ARN) for the extension.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameter names and values defined in the association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameter names and values defined in the association.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The version number for the extension defined in the association.
     * </p>
     * 
     * @return The version number for the extension defined in the association.
     */
    public final Integer extensionVersionNumber() {
        return extensionVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(extensionArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(extensionVersionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExtensionAssociationResponse)) {
            return false;
        }
        UpdateExtensionAssociationResponse other = (UpdateExtensionAssociationResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(extensionArn(), other.extensionArn())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(arn(), other.arn())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(extensionVersionNumber(), other.extensionVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateExtensionAssociationResponse").add("Id", id()).add("ExtensionArn", extensionArn())
                .add("ResourceArn", resourceArn()).add("Arn", arn()).add("Parameters", hasParameters() ? parameters() : null)
                .add("ExtensionVersionNumber", extensionVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ExtensionArn":
            return Optional.ofNullable(clazz.cast(extensionArn()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ExtensionVersionNumber":
            return Optional.ofNullable(clazz.cast(extensionVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ExtensionArn", EXTENSION_ARN_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("ExtensionVersionNumber", EXTENSION_VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateExtensionAssociationResponse, T> g) {
        return obj -> g.apply((UpdateExtensionAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateExtensionAssociationResponse> {
        /**
         * <p>
         * The system-generated ID for the association.
         * </p>
         * 
         * @param id
         *        The system-generated ID for the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the extension defined in the association.
         * </p>
         * 
         * @param extensionArn
         *        The ARN of the extension defined in the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionArn(String extensionArn);

        /**
         * <p>
         * The ARNs of applications, configuration profiles, or environments defined in the association.
         * </p>
         * 
         * @param resourceArn
         *        The ARNs of applications, configuration profiles, or environments defined in the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The system-generated Amazon Resource Name (ARN) for the extension.
         * </p>
         * 
         * @param arn
         *        The system-generated Amazon Resource Name (ARN) for the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The parameter names and values defined in the association.
         * </p>
         * 
         * @param parameters
         *        The parameter names and values defined in the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The version number for the extension defined in the association.
         * </p>
         * 
         * @param extensionVersionNumber
         *        The version number for the extension defined in the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionVersionNumber(Integer extensionVersionNumber);
    }

    static final class BuilderImpl extends AppConfigResponse.BuilderImpl implements Builder {
        private String id;

        private String extensionArn;

        private String resourceArn;

        private String arn;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Integer extensionVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExtensionAssociationResponse model) {
            super(model);
            id(model.id);
            extensionArn(model.extensionArn);
            resourceArn(model.resourceArn);
            arn(model.arn);
            parameters(model.parameters);
            extensionVersionNumber(model.extensionVersionNumber);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExtensionArn() {
            return extensionArn;
        }

        public final void setExtensionArn(String extensionArn) {
            this.extensionArn = extensionArn;
        }

        @Override
        public final Builder extensionArn(String extensionArn) {
            this.extensionArn = extensionArn;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParameterValueMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParameterValueMapCopier.copy(parameters);
            return this;
        }

        public final Integer getExtensionVersionNumber() {
            return extensionVersionNumber;
        }

        public final void setExtensionVersionNumber(Integer extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
        }

        @Override
        public final Builder extensionVersionNumber(Integer extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
            return this;
        }

        @Override
        public UpdateExtensionAssociationResponse build() {
            return new UpdateExtensionAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
