/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A parameter to configure deletion protection. Deletion protection prevents a user from deleting a configuration
 * profile or an environment if AppConfig has called either <a
 * href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
 * >GetLatestConfiguration</a> or for the configuration profile or from the environment during the specified interval.
 * </p>
 * <p>
 * The default interval specified by <code>ProtectionPeriodInMinutes</code> is 60. <code>DeletionProtectionCheck</code>
 * skips configuration profiles and environments that were created in the past hour.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletionProtectionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DeletionProtectionSettings.Builder, DeletionProtectionSettings> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(DeletionProtectionSettings::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Integer> PROTECTION_PERIOD_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("ProtectionPeriodInMinutes")
            .getter(getter(DeletionProtectionSettings::protectionPeriodInMinutes))
            .setter(setter(Builder::protectionPeriodInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionPeriodInMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            PROTECTION_PERIOD_IN_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Integer protectionPeriodInMinutes;

    private DeletionProtectionSettings(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.protectionPeriodInMinutes = builder.protectionPeriodInMinutes;
    }

    /**
     * <p>
     * A parameter that indicates if deletion protection is enabled or not.
     * </p>
     * 
     * @return A parameter that indicates if deletion protection is enabled or not.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The time interval during which AppConfig monitors for calls to <a href=
     * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     * >GetLatestConfiguration</a> or for a configuration profile or from an environment. AppConfig returns an error if
     * a user calls or for the designated configuration profile or environment. To bypass the error and delete a
     * configuration profile or an environment, specify <code>BYPASS</code> for the <code>DeletionProtectionCheck</code>
     * parameter for either or .
     * </p>
     * 
     * @return The time interval during which AppConfig monitors for calls to <a href=
     *         "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
     *         >GetLatestConfiguration</a> or for a configuration profile or from an environment. AppConfig returns an
     *         error if a user calls or for the designated configuration profile or environment. To bypass the error and
     *         delete a configuration profile or an environment, specify <code>BYPASS</code> for the
     *         <code>DeletionProtectionCheck</code> parameter for either or .
     */
    public final Integer protectionPeriodInMinutes() {
        return protectionPeriodInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(protectionPeriodInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletionProtectionSettings)) {
            return false;
        }
        DeletionProtectionSettings other = (DeletionProtectionSettings) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(protectionPeriodInMinutes(), other.protectionPeriodInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletionProtectionSettings").add("Enabled", enabled())
                .add("ProtectionPeriodInMinutes", protectionPeriodInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "ProtectionPeriodInMinutes":
            return Optional.ofNullable(clazz.cast(protectionPeriodInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("ProtectionPeriodInMinutes", PROTECTION_PERIOD_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletionProtectionSettings, T> g) {
        return obj -> g.apply((DeletionProtectionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeletionProtectionSettings> {
        /**
         * <p>
         * A parameter that indicates if deletion protection is enabled or not.
         * </p>
         * 
         * @param enabled
         *        A parameter that indicates if deletion protection is enabled or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The time interval during which AppConfig monitors for calls to <a href=
         * "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         * >GetLatestConfiguration</a> or for a configuration profile or from an environment. AppConfig returns an error
         * if a user calls or for the designated configuration profile or environment. To bypass the error and delete a
         * configuration profile or an environment, specify <code>BYPASS</code> for the
         * <code>DeletionProtectionCheck</code> parameter for either or .
         * </p>
         * 
         * @param protectionPeriodInMinutes
         *        The time interval during which AppConfig monitors for calls to <a href=
         *        "https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html"
         *        >GetLatestConfiguration</a> or for a configuration profile or from an environment. AppConfig returns
         *        an error if a user calls or for the designated configuration profile or environment. To bypass the
         *        error and delete a configuration profile or an environment, specify <code>BYPASS</code> for the
         *        <code>DeletionProtectionCheck</code> parameter for either or .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionPeriodInMinutes(Integer protectionPeriodInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Integer protectionPeriodInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletionProtectionSettings model) {
            enabled(model.enabled);
            protectionPeriodInMinutes(model.protectionPeriodInMinutes);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getProtectionPeriodInMinutes() {
            return protectionPeriodInMinutes;
        }

        public final void setProtectionPeriodInMinutes(Integer protectionPeriodInMinutes) {
            this.protectionPeriodInMinutes = protectionPeriodInMinutes;
        }

        @Override
        public final Builder protectionPeriodInMinutes(Integer protectionPeriodInMinutes) {
            this.protectionPeriodInMinutes = protectionPeriodInMinutes;
            return this;
        }

        @Override
        public DeletionProtectionSettings build() {
            return new DeletionProtectionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
