/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteHostedConfigurationVersionRequest extends AppConfigRequest implements
        ToCopyableBuilder<DeleteHostedConfigurationVersionRequest.Builder, DeleteHostedConfigurationVersionRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(DeleteHostedConfigurationVersionRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()).build();

    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationProfileId").getter(getter(DeleteHostedConfigurationVersionRequest::configurationProfileId))
            .setter(setter(Builder::configurationProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationProfileId").build())
            .build();

    private static final SdkField<Integer> VERSION_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VersionNumber").getter(getter(DeleteHostedConfigurationVersionRequest::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VersionNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CONFIGURATION_PROFILE_ID_FIELD, VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String configurationProfileId;

    private final Integer versionNumber;

    private DeleteHostedConfigurationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.configurationProfileId = builder.configurationProfileId;
        this.versionNumber = builder.versionNumber;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The configuration profile ID.
     * </p>
     * 
     * @return The configuration profile ID.
     */
    public final String configurationProfileId() {
        return configurationProfileId;
    }

    /**
     * <p>
     * The versions number to delete.
     * </p>
     * 
     * @return The versions number to delete.
     */
    public final Integer versionNumber() {
        return versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteHostedConfigurationVersionRequest)) {
            return false;
        }
        DeleteHostedConfigurationVersionRequest other = (DeleteHostedConfigurationVersionRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(configurationProfileId(), other.configurationProfileId())
                && Objects.equals(versionNumber(), other.versionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteHostedConfigurationVersionRequest").add("ApplicationId", applicationId())
                .add("ConfigurationProfileId", configurationProfileId()).add("VersionNumber", versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ConfigurationProfileId":
            return Optional.ofNullable(clazz.cast(configurationProfileId()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("ConfigurationProfileId", CONFIGURATION_PROFILE_ID_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteHostedConfigurationVersionRequest, T> g) {
        return obj -> g.apply((DeleteHostedConfigurationVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteHostedConfigurationVersionRequest> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The configuration profile ID.
         * </p>
         * 
         * @param configurationProfileId
         *        The configuration profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProfileId(String configurationProfileId);

        /**
         * <p>
         * The versions number to delete.
         * </p>
         * 
         * @param versionNumber
         *        The versions number to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Integer versionNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String configurationProfileId;

        private Integer versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteHostedConfigurationVersionRequest model) {
            super(model);
            applicationId(model.applicationId);
            configurationProfileId(model.configurationProfileId);
            versionNumber(model.versionNumber);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getConfigurationProfileId() {
            return configurationProfileId;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final Integer getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteHostedConfigurationVersionRequest build() {
            return new DeleteHostedConfigurationVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
