/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An action defines the tasks that the extension performs during the AppConfig workflow. Each action includes an action
 * point, as shown in the following list:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>PRE_CREATE_HOSTED_CONFIGURATION_VERSION</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>PRE_START_DEPLOYMENT</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AT_DEPLOYMENT_TICK</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ON_DEPLOYMENT_START</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ON_DEPLOYMENT_STEP</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ON_DEPLOYMENT_BAKING</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ON_DEPLOYMENT_COMPLETE</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ON_DEPLOYMENT_ROLLED_BACK</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * Each action also includes a name, a URI to an Lambda function, and an Amazon Resource Name (ARN) for an Identity and
 * Access Management assume role. You specify the name, URI, and ARN for each <i>action point</i> defined in the
 * extension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Action::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Action::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uri")
            .getter(getter(Action::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uri").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(Action::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            URI_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String uri;

    private final String roleArn;

    private Action(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.uri = builder.uri;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The action name.
     * </p>
     * 
     * @return The action name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Information about the action.
     * </p>
     * 
     * @return Information about the action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource
     * Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple
     * Notification Service topic, or the Amazon EventBridge default event bus.
     * </p>
     * 
     * @return The extension URI associated to the action point in the extension definition. The URI can be an Amazon
     *         Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue,
     *         an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(uri(), other.uri()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("Name", name()).add("Description", description()).add("Uri", uri())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Uri", URI_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * The action name.
         * </p>
         * 
         * @param name
         *        The action name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about the action.
         * </p>
         * 
         * @param description
         *        Information about the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The extension URI associated to the action point in the extension definition. The URI can be an Amazon
         * Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an
         * Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
         * </p>
         * 
         * @param uri
         *        The extension URI associated to the action point in the extension definition. The URI can be an Amazon
         *        Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service
         *        queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
         * </p>
         * 
         * @param roleArn
         *        An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String uri;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            name(model.name);
            description(model.description);
            uri(model.uri);
            roleArn(model.roleArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
