/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExtensionRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, GetExtensionRequest> {
    private static final SdkField<String> EXTENSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtensionIdentifier").getter(GetExtensionRequest.getter(GetExtensionRequest::extensionIdentifier)).setter(GetExtensionRequest.setter(Builder::extensionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ExtensionIdentifier").build()}).build();
    private static final SdkField<Integer> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VersionNumber").getter(GetExtensionRequest.getter(GetExtensionRequest::versionNumber)).setter(GetExtensionRequest.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version_number").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSION_IDENTIFIER_FIELD, VERSION_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetExtensionRequest.memberNameToFieldInitializer();
    private final String extensionIdentifier;
    private final Integer versionNumber;

    private GetExtensionRequest(BuilderImpl builder) {
        super(builder);
        this.extensionIdentifier = builder.extensionIdentifier;
        this.versionNumber = builder.versionNumber;
    }

    public final String extensionIdentifier() {
        return this.extensionIdentifier;
    }

    public final Integer versionNumber() {
        return this.versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExtensionRequest)) {
            return false;
        }
        GetExtensionRequest other = (GetExtensionRequest)((Object)obj);
        return Objects.equals(this.extensionIdentifier(), other.extensionIdentifier()) && Objects.equals(this.versionNumber(), other.versionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"GetExtensionRequest").add("ExtensionIdentifier", (Object)this.extensionIdentifier()).add("VersionNumber", (Object)this.versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExtensionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.extensionIdentifier()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExtensionIdentifier", EXTENSION_IDENTIFIER_FIELD);
        map.put("version_number", VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExtensionRequest, T> g) {
        return obj -> g.apply((GetExtensionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String extensionIdentifier;
        private Integer versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExtensionRequest model) {
            super(model);
            this.extensionIdentifier(model.extensionIdentifier);
            this.versionNumber(model.versionNumber);
        }

        public final String getExtensionIdentifier() {
            return this.extensionIdentifier;
        }

        public final void setExtensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
        }

        @Override
        public final Builder extensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
            return this;
        }

        public final Integer getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExtensionRequest build() {
            return new GetExtensionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExtensionRequest> {
        public Builder extensionIdentifier(String var1);

        public Builder versionNumber(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

