/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExtensionAssociationsRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, ListExtensionAssociationsRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(ListExtensionAssociationsRequest.getter(ListExtensionAssociationsRequest::resourceIdentifier)).setter(ListExtensionAssociationsRequest.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resource_identifier").build()}).build();
    private static final SdkField<String> EXTENSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtensionIdentifier").getter(ListExtensionAssociationsRequest.getter(ListExtensionAssociationsRequest::extensionIdentifier)).setter(ListExtensionAssociationsRequest.setter(Builder::extensionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("extension_identifier").build()}).build();
    private static final SdkField<Integer> EXTENSION_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExtensionVersionNumber").getter(ListExtensionAssociationsRequest.getter(ListExtensionAssociationsRequest::extensionVersionNumber)).setter(ListExtensionAssociationsRequest.setter(Builder::extensionVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("extension_version_number").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListExtensionAssociationsRequest.getter(ListExtensionAssociationsRequest::maxResults)).setter(ListExtensionAssociationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max_results").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListExtensionAssociationsRequest.getter(ListExtensionAssociationsRequest::nextToken)).setter(ListExtensionAssociationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next_token").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD, EXTENSION_IDENTIFIER_FIELD, EXTENSION_VERSION_NUMBER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListExtensionAssociationsRequest.memberNameToFieldInitializer();
    private final String resourceIdentifier;
    private final String extensionIdentifier;
    private final Integer extensionVersionNumber;
    private final Integer maxResults;
    private final String nextToken;

    private ListExtensionAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.extensionIdentifier = builder.extensionIdentifier;
        this.extensionVersionNumber = builder.extensionVersionNumber;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final String extensionIdentifier() {
        return this.extensionIdentifier;
    }

    public final Integer extensionVersionNumber() {
        return this.extensionVersionNumber;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExtensionAssociationsRequest)) {
            return false;
        }
        ListExtensionAssociationsRequest other = (ListExtensionAssociationsRequest)((Object)obj);
        return Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.extensionIdentifier(), other.extensionIdentifier()) && Objects.equals(this.extensionVersionNumber(), other.extensionVersionNumber()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExtensionAssociationsRequest").add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("ExtensionIdentifier", (Object)this.extensionIdentifier()).add("ExtensionVersionNumber", (Object)this.extensionVersionNumber()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "ExtensionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.extensionIdentifier()));
            }
            case "ExtensionVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.extensionVersionNumber()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resource_identifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("extension_identifier", EXTENSION_IDENTIFIER_FIELD);
        map.put("extension_version_number", EXTENSION_VERSION_NUMBER_FIELD);
        map.put("max_results", MAX_RESULTS_FIELD);
        map.put("next_token", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExtensionAssociationsRequest, T> g) {
        return obj -> g.apply((ListExtensionAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private String extensionIdentifier;
        private Integer extensionVersionNumber;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExtensionAssociationsRequest model) {
            super(model);
            this.resourceIdentifier(model.resourceIdentifier);
            this.extensionIdentifier(model.extensionIdentifier);
            this.extensionVersionNumber(model.extensionVersionNumber);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getExtensionIdentifier() {
            return this.extensionIdentifier;
        }

        public final void setExtensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
        }

        @Override
        public final Builder extensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
            return this;
        }

        public final Integer getExtensionVersionNumber() {
            return this.extensionVersionNumber;
        }

        public final void setExtensionVersionNumber(Integer extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
        }

        @Override
        public final Builder extensionVersionNumber(Integer extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExtensionAssociationsRequest build() {
            return new ListExtensionAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExtensionAssociationsRequest> {
        public Builder resourceIdentifier(String var1);

        public Builder extensionIdentifier(String var1);

        public Builder extensionVersionNumber(Integer var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

