/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appconfig.model.ValidatorType;
import software.amazon.awssdk.services.appconfig.model.ValidatorTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationProfileSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationProfileSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(ConfigurationProfileSummary.getter(ConfigurationProfileSummary::applicationId)).setter(ConfigurationProfileSummary.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ConfigurationProfileSummary.getter(ConfigurationProfileSummary::id)).setter(ConfigurationProfileSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ConfigurationProfileSummary.getter(ConfigurationProfileSummary::name)).setter(ConfigurationProfileSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationUri").getter(ConfigurationProfileSummary.getter(ConfigurationProfileSummary::locationUri)).setter(ConfigurationProfileSummary.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<List<String>> VALIDATOR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidatorTypes").getter(ConfigurationProfileSummary.getter(ConfigurationProfileSummary::validatorTypesAsStrings)).setter(ConfigurationProfileSummary.setter(Builder::validatorTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidatorTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ConfigurationProfileSummary.getter(ConfigurationProfileSummary::type)).setter(ConfigurationProfileSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ID_FIELD, NAME_FIELD, LOCATION_URI_FIELD, VALIDATOR_TYPES_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationProfileSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String id;
    private final String name;
    private final String locationUri;
    private final List<String> validatorTypes;
    private final String type;

    private ConfigurationProfileSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.id = builder.id;
        this.name = builder.name;
        this.locationUri = builder.locationUri;
        this.validatorTypes = builder.validatorTypes;
        this.type = builder.type;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String locationUri() {
        return this.locationUri;
    }

    public final List<ValidatorType> validatorTypes() {
        return ValidatorTypeListCopier.copyStringToEnum(this.validatorTypes);
    }

    public final boolean hasValidatorTypes() {
        return this.validatorTypes != null && !(this.validatorTypes instanceof SdkAutoConstructList);
    }

    public final List<String> validatorTypesAsStrings() {
        return this.validatorTypes;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidatorTypes() ? this.validatorTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationProfileSummary)) {
            return false;
        }
        ConfigurationProfileSummary other = (ConfigurationProfileSummary)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.locationUri(), other.locationUri()) && this.hasValidatorTypes() == other.hasValidatorTypes() && Objects.equals(this.validatorTypesAsStrings(), other.validatorTypesAsStrings()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationProfileSummary").add("ApplicationId", (Object)this.applicationId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("LocationUri", (Object)this.locationUri()).add("ValidatorTypes", this.hasValidatorTypes() ? this.validatorTypesAsStrings() : null).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "ValidatorTypes": {
                return Optional.ofNullable(clazz.cast(this.validatorTypesAsStrings()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("LocationUri", LOCATION_URI_FIELD);
        map.put("ValidatorTypes", VALIDATOR_TYPES_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationProfileSummary, T> g) {
        return obj -> g.apply((ConfigurationProfileSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String id;
        private String name;
        private String locationUri;
        private List<String> validatorTypes = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationProfileSummary model) {
            this.applicationId(model.applicationId);
            this.id(model.id);
            this.name(model.name);
            this.locationUri(model.locationUri);
            this.validatorTypesWithStrings(model.validatorTypes);
            this.type(model.type);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final Collection<String> getValidatorTypes() {
            if (this.validatorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validatorTypes;
        }

        public final void setValidatorTypes(Collection<String> validatorTypes) {
            this.validatorTypes = ValidatorTypeListCopier.copy(validatorTypes);
        }

        @Override
        public final Builder validatorTypesWithStrings(Collection<String> validatorTypes) {
            this.validatorTypes = ValidatorTypeListCopier.copy(validatorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validatorTypesWithStrings(String ... validatorTypes) {
            this.validatorTypesWithStrings(Arrays.asList(validatorTypes));
            return this;
        }

        @Override
        public final Builder validatorTypes(Collection<ValidatorType> validatorTypes) {
            this.validatorTypes = ValidatorTypeListCopier.copyEnumToString(validatorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validatorTypes(ValidatorType ... validatorTypes) {
            this.validatorTypes(Arrays.asList(validatorTypes));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public ConfigurationProfileSummary build() {
            return new ConfigurationProfileSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationProfileSummary> {
        public Builder applicationId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder locationUri(String var1);

        public Builder validatorTypesWithStrings(Collection<String> var1);

        public Builder validatorTypesWithStrings(String ... var1);

        public Builder validatorTypes(Collection<ValidatorType> var1);

        public Builder validatorTypes(ValidatorType ... var1);

        public Builder type(String var1);
    }
}

