/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionPoint {
    PRE_CREATE_HOSTED_CONFIGURATION_VERSION("PRE_CREATE_HOSTED_CONFIGURATION_VERSION"),
    PRE_START_DEPLOYMENT("PRE_START_DEPLOYMENT"),
    AT_DEPLOYMENT_TICK("AT_DEPLOYMENT_TICK"),
    ON_DEPLOYMENT_START("ON_DEPLOYMENT_START"),
    ON_DEPLOYMENT_STEP("ON_DEPLOYMENT_STEP"),
    ON_DEPLOYMENT_BAKING("ON_DEPLOYMENT_BAKING"),
    ON_DEPLOYMENT_COMPLETE("ON_DEPLOYMENT_COMPLETE"),
    ON_DEPLOYMENT_ROLLED_BACK("ON_DEPLOYMENT_ROLLED_BACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionPoint> VALUE_MAP;
    private final String value;

    private ActionPoint(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionPoint fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionPoint> knownValues() {
        EnumSet<ActionPoint> knownValues = EnumSet.allOf(ActionPoint.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionPoint.class, ActionPoint::toString);
    }
}

