/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appconfig.model.ParameterValueMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppliedExtension
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppliedExtension> {
    private static final SdkField<String> EXTENSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtensionId").getter(AppliedExtension.getter(AppliedExtension::extensionId)).setter(AppliedExtension.setter(Builder::extensionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionId").build()}).build();
    private static final SdkField<String> EXTENSION_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtensionAssociationId").getter(AppliedExtension.getter(AppliedExtension::extensionAssociationId)).setter(AppliedExtension.setter(Builder::extensionAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionAssociationId").build()}).build();
    private static final SdkField<Integer> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VersionNumber").getter(AppliedExtension.getter(AppliedExtension::versionNumber)).setter(AppliedExtension.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(AppliedExtension.getter(AppliedExtension::parameters)).setter(AppliedExtension.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSION_ID_FIELD, EXTENSION_ASSOCIATION_ID_FIELD, VERSION_NUMBER_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppliedExtension.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String extensionId;
    private final String extensionAssociationId;
    private final Integer versionNumber;
    private final Map<String, String> parameters;

    private AppliedExtension(BuilderImpl builder) {
        this.extensionId = builder.extensionId;
        this.extensionAssociationId = builder.extensionAssociationId;
        this.versionNumber = builder.versionNumber;
        this.parameters = builder.parameters;
    }

    public final String extensionId() {
        return this.extensionId;
    }

    public final String extensionAssociationId() {
        return this.extensionAssociationId;
    }

    public final Integer versionNumber() {
        return this.versionNumber;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppliedExtension)) {
            return false;
        }
        AppliedExtension other = (AppliedExtension)obj;
        return Objects.equals(this.extensionId(), other.extensionId()) && Objects.equals(this.extensionAssociationId(), other.extensionAssociationId()) && Objects.equals(this.versionNumber(), other.versionNumber()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"AppliedExtension").add("ExtensionId", (Object)this.extensionId()).add("ExtensionAssociationId", (Object)this.extensionAssociationId()).add("VersionNumber", (Object)this.versionNumber()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExtensionId": {
                return Optional.ofNullable(clazz.cast(this.extensionId()));
            }
            case "ExtensionAssociationId": {
                return Optional.ofNullable(clazz.cast(this.extensionAssociationId()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExtensionId", EXTENSION_ID_FIELD);
        map.put("ExtensionAssociationId", EXTENSION_ASSOCIATION_ID_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppliedExtension, T> g) {
        return obj -> g.apply((AppliedExtension)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String extensionId;
        private String extensionAssociationId;
        private Integer versionNumber;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppliedExtension model) {
            this.extensionId(model.extensionId);
            this.extensionAssociationId(model.extensionAssociationId);
            this.versionNumber(model.versionNumber);
            this.parameters(model.parameters);
        }

        public final String getExtensionId() {
            return this.extensionId;
        }

        public final void setExtensionId(String extensionId) {
            this.extensionId = extensionId;
        }

        @Override
        public final Builder extensionId(String extensionId) {
            this.extensionId = extensionId;
            return this;
        }

        public final String getExtensionAssociationId() {
            return this.extensionAssociationId;
        }

        public final void setExtensionAssociationId(String extensionAssociationId) {
            this.extensionAssociationId = extensionAssociationId;
        }

        @Override
        public final Builder extensionAssociationId(String extensionAssociationId) {
            this.extensionAssociationId = extensionAssociationId;
            return this;
        }

        public final Integer getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Integer versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParameterValueMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParameterValueMapCopier.copy(parameters);
            return this;
        }

        public AppliedExtension build() {
            return new AppliedExtension(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppliedExtension> {
        public Builder extensionId(String var1);

        public Builder extensionAssociationId(String var1);

        public Builder versionNumber(Integer var1);

        public Builder parameters(Map<String, String> var1);
    }
}

