/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.services.appconfig.model.Monitor;
import software.amazon.awssdk.services.appconfig.model.MonitorListCopier;
import software.amazon.awssdk.services.appconfig.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::applicationId)).setter(CreateEnvironmentRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::name)).setter(CreateEnvironmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::description)).setter(CreateEnvironmentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Monitor>> MONITORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Monitors").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::monitors)).setter(CreateEnvironmentRequest.setter(Builder::monitors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Monitor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::tags)).setter(CreateEnvironmentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, MONITORS_FIELD, TAGS_FIELD));
    private final String applicationId;
    private final String name;
    private final String description;
    private final List<Monitor> monitors;
    private final Map<String, String> tags;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.name = builder.name;
        this.description = builder.description;
        this.monitors = builder.monitors;
        this.tags = builder.tags;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasMonitors() {
        return this.monitors != null && !(this.monitors instanceof SdkAutoConstructList);
    }

    public final List<Monitor> monitors() {
        return this.monitors;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonitors() ? this.monitors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasMonitors() == other.hasMonitors() && Objects.equals(this.monitors(), other.monitors()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentRequest").add("ApplicationId", (Object)this.applicationId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Monitors", this.hasMonitors() ? this.monitors() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Monitors": {
                return Optional.ofNullable(clazz.cast(this.monitors()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String name;
        private String description;
        private List<Monitor> monitors = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.name(model.name);
            this.description(model.description);
            this.monitors(model.monitors);
            this.tags(model.tags);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Monitor.Builder> getMonitors() {
            List<Monitor.Builder> result = MonitorListCopier.copyToBuilder(this.monitors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitors(Collection<Monitor.BuilderImpl> monitors) {
            this.monitors = MonitorListCopier.copyFromBuilder(monitors);
        }

        @Override
        public final Builder monitors(Collection<Monitor> monitors) {
            this.monitors = MonitorListCopier.copy(monitors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitors(Monitor ... monitors) {
            this.monitors(Arrays.asList(monitors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitors(Consumer<Monitor.Builder> ... monitors) {
            this.monitors(Stream.of(monitors).map(c -> (Monitor)((Monitor.Builder)Monitor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentRequest> {
        public Builder applicationId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder monitors(Collection<Monitor> var1);

        public Builder monitors(Monitor ... var1);

        public Builder monitors(Consumer<Monitor.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

