/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appconfig.AppConfigClient;
import software.amazon.awssdk.services.appconfig.AppConfigClientBuilder;
import software.amazon.awssdk.services.appconfig.AppConfigServiceClientConfiguration;
import software.amazon.awssdk.services.appconfig.DefaultAppConfigBaseClientBuilder;
import software.amazon.awssdk.services.appconfig.DefaultAppConfigClient;
import software.amazon.awssdk.services.appconfig.endpoints.AppConfigEndpointProvider;

@SdkInternalApi
final class DefaultAppConfigClientBuilder
extends DefaultAppConfigBaseClientBuilder<AppConfigClientBuilder, AppConfigClient>
implements AppConfigClientBuilder {
    DefaultAppConfigClientBuilder() {
    }

    @Override
    public DefaultAppConfigClientBuilder endpointProvider(AppConfigEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppConfigClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAppConfigClientBuilder.validateClientOptions(clientConfiguration);
        AppConfigServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAppConfigClient client = new DefaultAppConfigClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AppConfigServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AppConfigServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

