/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appconfig.AppConfigClient;
import software.amazon.awssdk.services.appconfig.internal.UserAgentUtils;
import software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest;
import software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesResponse;

public class ListConfigurationProfilesIterable
implements SdkIterable<ListConfigurationProfilesResponse> {
    private final AppConfigClient client;
    private final ListConfigurationProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigurationProfilesIterable(AppConfigClient client, ListConfigurationProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfigurationProfilesResponseFetcher();
    }

    public Iterator<ListConfigurationProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListConfigurationProfilesResponseFetcher
    implements SyncPageFetcher<ListConfigurationProfilesResponse> {
        private ListConfigurationProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigurationProfilesResponse nextPage(ListConfigurationProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationProfilesIterable.this.client.listConfigurationProfiles(ListConfigurationProfilesIterable.this.firstRequest);
            }
            return ListConfigurationProfilesIterable.this.client.listConfigurationProfiles((ListConfigurationProfilesRequest)((Object)ListConfigurationProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

