/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.AppConfigException;
import software.amazon.awssdk.services.appconfig.model.BadRequestDetails;
import software.amazon.awssdk.services.appconfig.model.BadRequestReason;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BadRequestException
extends AppConfigException
implements ToCopyableBuilder<Builder, BadRequestException> {
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(BadRequestException.getter(BadRequestException::reasonAsString)).setter(BadRequestException.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<BadRequestDetails> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Details").getter(BadRequestException.getter(BadRequestException::details)).setter(BadRequestException.setter(Builder::details)).constructor(BadRequestDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reason;
    private final BadRequestDetails details;

    private BadRequestException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
        this.details = builder.details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public BadRequestReason reason() {
        return BadRequestReason.fromValue(this.reason);
    }

    public String reasonAsString() {
        return this.reason;
    }

    public BadRequestDetails details() {
        return this.details;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BadRequestException, T> g) {
        return obj -> g.apply((BadRequestException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigException.BuilderImpl
    implements Builder {
        private String reason;
        private BadRequestDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(BadRequestException model) {
            super(model);
            this.reason(model.reason);
            this.details(model.details);
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(BadRequestReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final BadRequestDetails.Builder getDetails() {
            return this.details != null ? this.details.toBuilder() : null;
        }

        public final void setDetails(BadRequestDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(BadRequestDetails details) {
            this.details = details;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BadRequestException build() {
            return new BadRequestException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BadRequestException>,
    AppConfigException.Builder {
        public Builder reason(String var1);

        public Builder reason(BadRequestReason var1);

        public Builder details(BadRequestDetails var1);

        default public Builder details(Consumer<BadRequestDetails.Builder> details) {
            return this.details((BadRequestDetails)((BadRequestDetails.Builder)BadRequestDetails.builder().applyMutation(details)).build());
        }

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

