/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeploymentState {
    BAKING("BAKING"),
    VALIDATING("VALIDATING"),
    DEPLOYING("DEPLOYING"),
    COMPLETE("COMPLETE"),
    ROLLING_BACK("ROLLING_BACK"),
    ROLLED_BACK("ROLLED_BACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeploymentState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeploymentState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentState> knownValues() {
        return Stream.of(DeploymentState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

