/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeploymentStrategyRequest extends AppConfigRequest implements
        ToCopyableBuilder<UpdateDeploymentStrategyRequest.Builder, UpdateDeploymentStrategyRequest> {
    private static final SdkField<String> DEPLOYMENT_STRATEGY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStrategyId").getter(getter(UpdateDeploymentStrategyRequest::deploymentStrategyId))
            .setter(setter(Builder::deploymentStrategyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DeploymentStrategyId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateDeploymentStrategyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> DEPLOYMENT_DURATION_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeploymentDurationInMinutes")
            .getter(getter(UpdateDeploymentStrategyRequest::deploymentDurationInMinutes))
            .setter(setter(Builder::deploymentDurationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentDurationInMinutes")
                    .build()).build();

    private static final SdkField<Integer> FINAL_BAKE_TIME_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FinalBakeTimeInMinutes").getter(getter(UpdateDeploymentStrategyRequest::finalBakeTimeInMinutes))
            .setter(setter(Builder::finalBakeTimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBakeTimeInMinutes").build())
            .build();

    private static final SdkField<Float> GROWTH_FACTOR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("GrowthFactor").getter(getter(UpdateDeploymentStrategyRequest::growthFactor))
            .setter(setter(Builder::growthFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthFactor").build()).build();

    private static final SdkField<String> GROWTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrowthType").getter(getter(UpdateDeploymentStrategyRequest::growthTypeAsString))
            .setter(setter(Builder::growthType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_STRATEGY_ID_FIELD,
            DESCRIPTION_FIELD, DEPLOYMENT_DURATION_IN_MINUTES_FIELD, FINAL_BAKE_TIME_IN_MINUTES_FIELD, GROWTH_FACTOR_FIELD,
            GROWTH_TYPE_FIELD));

    private final String deploymentStrategyId;

    private final String description;

    private final Integer deploymentDurationInMinutes;

    private final Integer finalBakeTimeInMinutes;

    private final Float growthFactor;

    private final String growthType;

    private UpdateDeploymentStrategyRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentStrategyId = builder.deploymentStrategyId;
        this.description = builder.description;
        this.deploymentDurationInMinutes = builder.deploymentDurationInMinutes;
        this.finalBakeTimeInMinutes = builder.finalBakeTimeInMinutes;
        this.growthFactor = builder.growthFactor;
        this.growthType = builder.growthType;
    }

    /**
     * <p>
     * The deployment strategy ID.
     * </p>
     * 
     * @return The deployment strategy ID.
     */
    public final String deploymentStrategyId() {
        return deploymentStrategyId;
    }

    /**
     * <p>
     * A description of the deployment strategy.
     * </p>
     * 
     * @return A description of the deployment strategy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Total amount of time for a deployment to last.
     * </p>
     * 
     * @return Total amount of time for a deployment to last.
     */
    public final Integer deploymentDurationInMinutes() {
        return deploymentDurationInMinutes;
    }

    /**
     * <p>
     * The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no longer
     * eligible for automatic roll back.
     * </p>
     * 
     * @return The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no
     *         longer eligible for automatic roll back.
     */
    public final Integer finalBakeTimeInMinutes() {
        return finalBakeTimeInMinutes;
    }

    /**
     * <p>
     * The percentage of targets to receive a deployed configuration during each interval.
     * </p>
     * 
     * @return The percentage of targets to receive a deployed configuration during each interval.
     */
    public final Float growthFactor() {
        return growthFactor;
    }

    /**
     * <p>
     * The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:
     * </p>
     * <p>
     * <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly
     * distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially
     * makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed,
     * the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the
     * deployed configuration.
     * </p>
     * <p>
     * <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula:
     * <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and
     * <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you
     * specify a growth factor of 2, then the system rolls out the configuration as follows:
     * </p>
     * <p>
     * <code>2*(2^0)</code>
     * </p>
     * <p>
     * <code>2*(2^1)</code>
     * </p>
     * <p>
     * <code>2*(2^2)</code>
     * </p>
     * <p>
     * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the
     * targets, and continues until the configuration has been deployed to all targets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #growthType} will
     * return {@link GrowthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #growthTypeAsString}.
     * </p>
     * 
     * @return The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth
     *         types:</p>
     *         <p>
     *         <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor
     *         evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor
     *         of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the
     *         deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of
     *         the targets are set to receive the deployed configuration.
     *         </p>
     *         <p>
     *         <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following
     *         formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user
     *         and <code>N</code> is the number of steps until the configuration is deployed to all targets. For
     *         example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:
     *         </p>
     *         <p>
     *         <code>2*(2^0)</code>
     *         </p>
     *         <p>
     *         <code>2*(2^1)</code>
     *         </p>
     *         <p>
     *         <code>2*(2^2)</code>
     *         </p>
     *         <p>
     *         Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of
     *         the targets, and continues until the configuration has been deployed to all targets.
     * @see GrowthType
     */
    public final GrowthType growthType() {
        return GrowthType.fromValue(growthType);
    }

    /**
     * <p>
     * The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:
     * </p>
     * <p>
     * <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly
     * distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially
     * makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed,
     * the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the
     * deployed configuration.
     * </p>
     * <p>
     * <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula:
     * <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and
     * <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you
     * specify a growth factor of 2, then the system rolls out the configuration as follows:
     * </p>
     * <p>
     * <code>2*(2^0)</code>
     * </p>
     * <p>
     * <code>2*(2^1)</code>
     * </p>
     * <p>
     * <code>2*(2^2)</code>
     * </p>
     * <p>
     * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the
     * targets, and continues until the configuration has been deployed to all targets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #growthType} will
     * return {@link GrowthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #growthTypeAsString}.
     * </p>
     * 
     * @return The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth
     *         types:</p>
     *         <p>
     *         <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor
     *         evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor
     *         of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the
     *         deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of
     *         the targets are set to receive the deployed configuration.
     *         </p>
     *         <p>
     *         <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following
     *         formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user
     *         and <code>N</code> is the number of steps until the configuration is deployed to all targets. For
     *         example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:
     *         </p>
     *         <p>
     *         <code>2*(2^0)</code>
     *         </p>
     *         <p>
     *         <code>2*(2^1)</code>
     *         </p>
     *         <p>
     *         <code>2*(2^2)</code>
     *         </p>
     *         <p>
     *         Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of
     *         the targets, and continues until the configuration has been deployed to all targets.
     * @see GrowthType
     */
    public final String growthTypeAsString() {
        return growthType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(finalBakeTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(growthFactor());
        hashCode = 31 * hashCode + Objects.hashCode(growthTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentStrategyRequest)) {
            return false;
        }
        UpdateDeploymentStrategyRequest other = (UpdateDeploymentStrategyRequest) obj;
        return Objects.equals(deploymentStrategyId(), other.deploymentStrategyId())
                && Objects.equals(description(), other.description())
                && Objects.equals(deploymentDurationInMinutes(), other.deploymentDurationInMinutes())
                && Objects.equals(finalBakeTimeInMinutes(), other.finalBakeTimeInMinutes())
                && Objects.equals(growthFactor(), other.growthFactor())
                && Objects.equals(growthTypeAsString(), other.growthTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDeploymentStrategyRequest").add("DeploymentStrategyId", deploymentStrategyId())
                .add("Description", description()).add("DeploymentDurationInMinutes", deploymentDurationInMinutes())
                .add("FinalBakeTimeInMinutes", finalBakeTimeInMinutes()).add("GrowthFactor", growthFactor())
                .add("GrowthType", growthTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentStrategyId":
            return Optional.ofNullable(clazz.cast(deploymentStrategyId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeploymentDurationInMinutes":
            return Optional.ofNullable(clazz.cast(deploymentDurationInMinutes()));
        case "FinalBakeTimeInMinutes":
            return Optional.ofNullable(clazz.cast(finalBakeTimeInMinutes()));
        case "GrowthFactor":
            return Optional.ofNullable(clazz.cast(growthFactor()));
        case "GrowthType":
            return Optional.ofNullable(clazz.cast(growthTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeploymentStrategyRequest, T> g) {
        return obj -> g.apply((UpdateDeploymentStrategyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDeploymentStrategyRequest> {
        /**
         * <p>
         * The deployment strategy ID.
         * </p>
         * 
         * @param deploymentStrategyId
         *        The deployment strategy ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStrategyId(String deploymentStrategyId);

        /**
         * <p>
         * A description of the deployment strategy.
         * </p>
         * 
         * @param description
         *        A description of the deployment strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Total amount of time for a deployment to last.
         * </p>
         * 
         * @param deploymentDurationInMinutes
         *        Total amount of time for a deployment to last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes);

        /**
         * <p>
         * The amount of time AppConfig monitors for alarms before considering the deployment to be complete and no
         * longer eligible for automatic roll back.
         * </p>
         * 
         * @param finalBakeTimeInMinutes
         *        The amount of time AppConfig monitors for alarms before considering the deployment to be complete and
         *        no longer eligible for automatic roll back.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes);

        /**
         * <p>
         * The percentage of targets to receive a deployed configuration during each interval.
         * </p>
         * 
         * @param growthFactor
         *        The percentage of targets to receive a deployed configuration during each interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder growthFactor(Float growthFactor);

        /**
         * <p>
         * The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth
         * types:
         * </p>
         * <p>
         * <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly
         * distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20
         * initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time
         * has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set
         * to receive the deployed configuration.
         * </p>
         * <p>
         * <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following
         * formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and
         * <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you
         * specify a growth factor of 2, then the system rolls out the configuration as follows:
         * </p>
         * <p>
         * <code>2*(2^0)</code>
         * </p>
         * <p>
         * <code>2*(2^1)</code>
         * </p>
         * <p>
         * <code>2*(2^2)</code>
         * </p>
         * <p>
         * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the
         * targets, and continues until the configuration has been deployed to all targets.
         * </p>
         * 
         * @param growthType
         *        The algorithm used to define how percentage grows over time. AWS AppConfig supports the following
         *        growth types:</p>
         *        <p>
         *        <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor
         *        evenly distributed over the deployment time. For example, a linear deployment that uses a growth
         *        factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of
         *        the deployment time has passed, the system updates the percentage to 40 percent. This continues until
         *        100% of the targets are set to receive the deployed configuration.
         *        </p>
         *        <p>
         *        <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the
         *        following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor
         *        specified by the user and <code>N</code> is the number of steps until the configuration is deployed to
         *        all targets. For example, if you specify a growth factor of 2, then the system rolls out the
         *        configuration as follows:
         *        </p>
         *        <p>
         *        <code>2*(2^0)</code>
         *        </p>
         *        <p>
         *        <code>2*(2^1)</code>
         *        </p>
         *        <p>
         *        <code>2*(2^2)</code>
         *        </p>
         *        <p>
         *        Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8%
         *        of the targets, and continues until the configuration has been deployed to all targets.
         * @see GrowthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrowthType
         */
        Builder growthType(String growthType);

        /**
         * <p>
         * The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth
         * types:
         * </p>
         * <p>
         * <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly
         * distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20
         * initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time
         * has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set
         * to receive the deployed configuration.
         * </p>
         * <p>
         * <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following
         * formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and
         * <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you
         * specify a growth factor of 2, then the system rolls out the configuration as follows:
         * </p>
         * <p>
         * <code>2*(2^0)</code>
         * </p>
         * <p>
         * <code>2*(2^1)</code>
         * </p>
         * <p>
         * <code>2*(2^2)</code>
         * </p>
         * <p>
         * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the
         * targets, and continues until the configuration has been deployed to all targets.
         * </p>
         * 
         * @param growthType
         *        The algorithm used to define how percentage grows over time. AWS AppConfig supports the following
         *        growth types:</p>
         *        <p>
         *        <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor
         *        evenly distributed over the deployment time. For example, a linear deployment that uses a growth
         *        factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of
         *        the deployment time has passed, the system updates the percentage to 40 percent. This continues until
         *        100% of the targets are set to receive the deployed configuration.
         *        </p>
         *        <p>
         *        <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the
         *        following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor
         *        specified by the user and <code>N</code> is the number of steps until the configuration is deployed to
         *        all targets. For example, if you specify a growth factor of 2, then the system rolls out the
         *        configuration as follows:
         *        </p>
         *        <p>
         *        <code>2*(2^0)</code>
         *        </p>
         *        <p>
         *        <code>2*(2^1)</code>
         *        </p>
         *        <p>
         *        <code>2*(2^2)</code>
         *        </p>
         *        <p>
         *        Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8%
         *        of the targets, and continues until the configuration has been deployed to all targets.
         * @see GrowthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrowthType
         */
        Builder growthType(GrowthType growthType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String deploymentStrategyId;

        private String description;

        private Integer deploymentDurationInMinutes;

        private Integer finalBakeTimeInMinutes;

        private Float growthFactor;

        private String growthType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeploymentStrategyRequest model) {
            super(model);
            deploymentStrategyId(model.deploymentStrategyId);
            description(model.description);
            deploymentDurationInMinutes(model.deploymentDurationInMinutes);
            finalBakeTimeInMinutes(model.finalBakeTimeInMinutes);
            growthFactor(model.growthFactor);
            growthType(model.growthType);
        }

        public final String getDeploymentStrategyId() {
            return deploymentStrategyId;
        }

        @Override
        public final Builder deploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
            return this;
        }

        public final void setDeploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getDeploymentDurationInMinutes() {
            return deploymentDurationInMinutes;
        }

        @Override
        public final Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
            return this;
        }

        public final void setDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
        }

        public final Integer getFinalBakeTimeInMinutes() {
            return finalBakeTimeInMinutes;
        }

        @Override
        public final Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
            return this;
        }

        public final void setFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
        }

        public final Float getGrowthFactor() {
            return growthFactor;
        }

        @Override
        public final Builder growthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        public final void setGrowthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
        }

        public final String getGrowthType() {
            return growthType;
        }

        @Override
        public final Builder growthType(String growthType) {
            this.growthType = growthType;
            return this;
        }

        @Override
        public final Builder growthType(GrowthType growthType) {
            this.growthType(growthType == null ? null : growthType.toString());
            return this;
        }

        public final void setGrowthType(String growthType) {
            this.growthType = growthType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeploymentStrategyRequest build() {
            return new UpdateDeploymentStrategyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
