/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDeploymentRequest extends AppConfigRequest implements
        ToCopyableBuilder<StartDeploymentRequest.Builder, StartDeploymentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(StartDeploymentRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(StartDeploymentRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentId").build()).build();

    private static final SdkField<String> DEPLOYMENT_STRATEGY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStrategyId").getter(getter(StartDeploymentRequest::deploymentStrategyId))
            .setter(setter(Builder::deploymentStrategyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStrategyId").build())
            .build();

    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationProfileId").getter(getter(StartDeploymentRequest::configurationProfileId))
            .setter(setter(Builder::configurationProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationProfileId").build())
            .build();

    private static final SdkField<String> CONFIGURATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationVersion").getter(getter(StartDeploymentRequest::configurationVersion))
            .setter(setter(Builder::configurationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationVersion").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartDeploymentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(StartDeploymentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ENVIRONMENT_ID_FIELD, DEPLOYMENT_STRATEGY_ID_FIELD, CONFIGURATION_PROFILE_ID_FIELD, CONFIGURATION_VERSION_FIELD,
            DESCRIPTION_FIELD, TAGS_FIELD));

    private final String applicationId;

    private final String environmentId;

    private final String deploymentStrategyId;

    private final String configurationProfileId;

    private final String configurationVersion;

    private final String description;

    private final Map<String, String> tags;

    private StartDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.environmentId = builder.environmentId;
        this.deploymentStrategyId = builder.deploymentStrategyId;
        this.configurationProfileId = builder.configurationProfileId;
        this.configurationVersion = builder.configurationVersion;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The environment ID.
     * </p>
     * 
     * @return The environment ID.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The deployment strategy ID.
     * </p>
     * 
     * @return The deployment strategy ID.
     */
    public final String deploymentStrategyId() {
        return deploymentStrategyId;
    }

    /**
     * <p>
     * The configuration profile ID.
     * </p>
     * 
     * @return The configuration profile ID.
     */
    public final String configurationProfileId() {
        return configurationProfileId;
    }

    /**
     * <p>
     * The configuration version to deploy.
     * </p>
     * 
     * @return The configuration version to deploy.
     */
    public final String configurationVersion() {
        return configurationVersion;
    }

    /**
     * <p>
     * A description of the deployment.
     * </p>
     * 
     * @return A description of the deployment.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag
     * consists of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each
     *         tag consists of a key and an optional value, both of which you define.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeploymentRequest)) {
            return false;
        }
        StartDeploymentRequest other = (StartDeploymentRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(deploymentStrategyId(), other.deploymentStrategyId())
                && Objects.equals(configurationProfileId(), other.configurationProfileId())
                && Objects.equals(configurationVersion(), other.configurationVersion())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDeploymentRequest").add("ApplicationId", applicationId())
                .add("EnvironmentId", environmentId()).add("DeploymentStrategyId", deploymentStrategyId())
                .add("ConfigurationProfileId", configurationProfileId()).add("ConfigurationVersion", configurationVersion())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "DeploymentStrategyId":
            return Optional.ofNullable(clazz.cast(deploymentStrategyId()));
        case "ConfigurationProfileId":
            return Optional.ofNullable(clazz.cast(configurationProfileId()));
        case "ConfigurationVersion":
            return Optional.ofNullable(clazz.cast(configurationVersion()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDeploymentRequest, T> g) {
        return obj -> g.apply((StartDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartDeploymentRequest> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The environment ID.
         * </p>
         * 
         * @param environmentId
         *        The environment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The deployment strategy ID.
         * </p>
         * 
         * @param deploymentStrategyId
         *        The deployment strategy ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStrategyId(String deploymentStrategyId);

        /**
         * <p>
         * The configuration profile ID.
         * </p>
         * 
         * @param configurationProfileId
         *        The configuration profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProfileId(String configurationProfileId);

        /**
         * <p>
         * The configuration version to deploy.
         * </p>
         * 
         * @param configurationVersion
         *        The configuration version to deploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationVersion(String configurationVersion);

        /**
         * <p>
         * A description of the deployment.
         * </p>
         * 
         * @param description
         *        A description of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * 
         * @param tags
         *        Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each
         *        tag consists of a key and an optional value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String environmentId;

        private String deploymentStrategyId;

        private String configurationProfileId;

        private String configurationVersion;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeploymentRequest model) {
            super(model);
            applicationId(model.applicationId);
            environmentId(model.environmentId);
            deploymentStrategyId(model.deploymentStrategyId);
            configurationProfileId(model.configurationProfileId);
            configurationVersion(model.configurationVersion);
            description(model.description);
            tags(model.tags);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getDeploymentStrategyId() {
            return deploymentStrategyId;
        }

        @Override
        public final Builder deploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
            return this;
        }

        public final void setDeploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
        }

        public final String getConfigurationProfileId() {
            return configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        public final String getConfigurationVersion() {
            return configurationVersion;
        }

        @Override
        public final Builder configurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
            return this;
        }

        public final void setConfigurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeploymentRequest build() {
            return new StartDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
