/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.services.appconfig.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDeploymentRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, StartDeploymentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(StartDeploymentRequest.getter(StartDeploymentRequest::applicationId)).setter(StartDeploymentRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(StartDeploymentRequest.getter(StartDeploymentRequest::environmentId)).setter(StartDeploymentRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStrategyId").getter(StartDeploymentRequest.getter(StartDeploymentRequest::deploymentStrategyId)).setter(StartDeploymentRequest.setter(Builder::deploymentStrategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStrategyId").build()}).build();
    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationProfileId").getter(StartDeploymentRequest.getter(StartDeploymentRequest::configurationProfileId)).setter(StartDeploymentRequest.setter(Builder::configurationProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationProfileId").build()}).build();
    private static final SdkField<String> CONFIGURATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationVersion").getter(StartDeploymentRequest.getter(StartDeploymentRequest::configurationVersion)).setter(StartDeploymentRequest.setter(Builder::configurationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartDeploymentRequest.getter(StartDeploymentRequest::description)).setter(StartDeploymentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(StartDeploymentRequest.getter(StartDeploymentRequest::tags)).setter(StartDeploymentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ENVIRONMENT_ID_FIELD, DEPLOYMENT_STRATEGY_ID_FIELD, CONFIGURATION_PROFILE_ID_FIELD, CONFIGURATION_VERSION_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private final String applicationId;
    private final String environmentId;
    private final String deploymentStrategyId;
    private final String configurationProfileId;
    private final String configurationVersion;
    private final String description;
    private final Map<String, String> tags;

    private StartDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.environmentId = builder.environmentId;
        this.deploymentStrategyId = builder.deploymentStrategyId;
        this.configurationProfileId = builder.configurationProfileId;
        this.configurationVersion = builder.configurationVersion;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String deploymentStrategyId() {
        return this.deploymentStrategyId;
    }

    public String configurationProfileId() {
        return this.configurationProfileId;
    }

    public String configurationVersion() {
        return this.configurationVersion;
    }

    public String description() {
        return this.description;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeploymentRequest)) {
            return false;
        }
        StartDeploymentRequest other = (StartDeploymentRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.deploymentStrategyId(), other.deploymentStrategyId()) && Objects.equals(this.configurationProfileId(), other.configurationProfileId()) && Objects.equals(this.configurationVersion(), other.configurationVersion()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"StartDeploymentRequest").add("ApplicationId", (Object)this.applicationId()).add("EnvironmentId", (Object)this.environmentId()).add("DeploymentStrategyId", (Object)this.deploymentStrategyId()).add("ConfigurationProfileId", (Object)this.configurationProfileId()).add("ConfigurationVersion", (Object)this.configurationVersion()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "DeploymentStrategyId": {
                return Optional.ofNullable(clazz.cast(this.deploymentStrategyId()));
            }
            case "ConfigurationProfileId": {
                return Optional.ofNullable(clazz.cast(this.configurationProfileId()));
            }
            case "ConfigurationVersion": {
                return Optional.ofNullable(clazz.cast(this.configurationVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDeploymentRequest, T> g) {
        return obj -> g.apply((StartDeploymentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String environmentId;
        private String deploymentStrategyId;
        private String configurationProfileId;
        private String configurationVersion;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeploymentRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.environmentId(model.environmentId);
            this.deploymentStrategyId(model.deploymentStrategyId);
            this.configurationProfileId(model.configurationProfileId);
            this.configurationVersion(model.configurationVersion);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getDeploymentStrategyId() {
            return this.deploymentStrategyId;
        }

        @Override
        public final Builder deploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
            return this;
        }

        public final void setDeploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
        }

        public final String getConfigurationProfileId() {
            return this.configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        public final String getConfigurationVersion() {
            return this.configurationVersion;
        }

        @Override
        public final Builder configurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
            return this;
        }

        public final void setConfigurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeploymentRequest build() {
            return new StartDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDeploymentRequest> {
        public Builder applicationId(String var1);

        public Builder environmentId(String var1);

        public Builder deploymentStrategyId(String var1);

        public Builder configurationProfileId(String var1);

        public Builder configurationVersion(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

