/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.DeploymentEventType;
import software.amazon.awssdk.services.appconfig.model.TriggeredBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentEvent> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentEvent.getter(DeploymentEvent::eventTypeAsString)).setter(DeploymentEvent.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()}).build();
    private static final SdkField<String> TRIGGERED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentEvent.getter(DeploymentEvent::triggeredByAsString)).setter(DeploymentEvent.setter(Builder::triggeredBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggeredBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentEvent.getter(DeploymentEvent::description)).setter(DeploymentEvent.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> OCCURRED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DeploymentEvent.getter(DeploymentEvent::occurredAt)).setter(DeploymentEvent.setter(Builder::occurredAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurredAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD, TRIGGERED_BY_FIELD, DESCRIPTION_FIELD, OCCURRED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventType;
    private final String triggeredBy;
    private final String description;
    private final Instant occurredAt;

    private DeploymentEvent(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.triggeredBy = builder.triggeredBy;
        this.description = builder.description;
        this.occurredAt = builder.occurredAt;
    }

    public DeploymentEventType eventType() {
        return DeploymentEventType.fromValue(this.eventType);
    }

    public String eventTypeAsString() {
        return this.eventType;
    }

    public TriggeredBy triggeredBy() {
        return TriggeredBy.fromValue(this.triggeredBy);
    }

    public String triggeredByAsString() {
        return this.triggeredBy;
    }

    public String description() {
        return this.description;
    }

    public Instant occurredAt() {
        return this.occurredAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggeredByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.occurredAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentEvent)) {
            return false;
        }
        DeploymentEvent other = (DeploymentEvent)obj;
        return Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.triggeredByAsString(), other.triggeredByAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.occurredAt(), other.occurredAt());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentEvent").add("EventType", (Object)this.eventTypeAsString()).add("TriggeredBy", (Object)this.triggeredByAsString()).add("Description", (Object)this.description()).add("OccurredAt", (Object)this.occurredAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "TriggeredBy": {
                return Optional.ofNullable(clazz.cast(this.triggeredByAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OccurredAt": {
                return Optional.ofNullable(clazz.cast(this.occurredAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentEvent, T> g) {
        return obj -> g.apply((DeploymentEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventType;
        private String triggeredBy;
        private String description;
        private Instant occurredAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentEvent model) {
            this.eventType(model.eventType);
            this.triggeredBy(model.triggeredBy);
            this.description(model.description);
            this.occurredAt(model.occurredAt);
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(DeploymentEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final String getTriggeredBy() {
            return this.triggeredBy;
        }

        @Override
        public final Builder triggeredBy(String triggeredBy) {
            this.triggeredBy = triggeredBy;
            return this;
        }

        @Override
        public final Builder triggeredBy(TriggeredBy triggeredBy) {
            this.triggeredBy(triggeredBy == null ? null : triggeredBy.toString());
            return this;
        }

        public final void setTriggeredBy(String triggeredBy) {
            this.triggeredBy = triggeredBy;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getOccurredAt() {
            return this.occurredAt;
        }

        @Override
        public final Builder occurredAt(Instant occurredAt) {
            this.occurredAt = occurredAt;
            return this;
        }

        public final void setOccurredAt(Instant occurredAt) {
            this.occurredAt = occurredAt;
        }

        public DeploymentEvent build() {
            return new DeploymentEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentEvent> {
        public Builder eventType(String var1);

        public Builder eventType(DeploymentEventType var1);

        public Builder triggeredBy(String var1);

        public Builder triggeredBy(TriggeredBy var1);

        public Builder description(String var1);

        public Builder occurredAt(Instant var1);
    }
}

