/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.ProtocolType;
import software.amazon.awssdk.services.apigatewayv2.model.TagsCopier;
import software.amazon.awssdk.services.apigatewayv2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Api
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Api> {
    private static final SdkField<String> API_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Api.getter(Api::apiEndpoint)).setter(Api.setter(Builder::apiEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiEndpoint").build()}).build();
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Api.getter(Api::apiId)).setter(Api.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()}).build();
    private static final SdkField<String> API_KEY_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Api.getter(Api::apiKeySelectionExpression)).setter(Api.setter(Builder::apiKeySelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySelectionExpression").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Api.getter(Api::createdDate)).setter(Api.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Api.getter(Api::description)).setter(Api.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> DISABLE_SCHEMA_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Api.getter(Api::disableSchemaValidation)).setter(Api.setter(Builder::disableSchemaValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSchemaValidation").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Api.getter(Api::name)).setter(Api.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Api.getter(Api::protocolTypeAsString)).setter(Api.setter(Builder::protocolType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolType").build()}).build();
    private static final SdkField<String> ROUTE_SELECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Api.getter(Api::routeSelectionExpression)).setter(Api.setter(Builder::routeSelectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSelectionExpression").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Api.getter(Api::version)).setter(Api.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<List<String>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Api.getter(Api::warnings)).setter(Api.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Api.getter(Api::tags)).setter(Api.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ENDPOINT_FIELD, API_ID_FIELD, API_KEY_SELECTION_EXPRESSION_FIELD, CREATED_DATE_FIELD, DESCRIPTION_FIELD, DISABLE_SCHEMA_VALIDATION_FIELD, NAME_FIELD, PROTOCOL_TYPE_FIELD, ROUTE_SELECTION_EXPRESSION_FIELD, VERSION_FIELD, WARNINGS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String apiEndpoint;
    private final String apiId;
    private final String apiKeySelectionExpression;
    private final Instant createdDate;
    private final String description;
    private final Boolean disableSchemaValidation;
    private final String name;
    private final String protocolType;
    private final String routeSelectionExpression;
    private final String version;
    private final List<String> warnings;
    private final Map<String, String> tags;

    private Api(BuilderImpl builder) {
        this.apiEndpoint = builder.apiEndpoint;
        this.apiId = builder.apiId;
        this.apiKeySelectionExpression = builder.apiKeySelectionExpression;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.disableSchemaValidation = builder.disableSchemaValidation;
        this.name = builder.name;
        this.protocolType = builder.protocolType;
        this.routeSelectionExpression = builder.routeSelectionExpression;
        this.version = builder.version;
        this.warnings = builder.warnings;
        this.tags = builder.tags;
    }

    public String apiEndpoint() {
        return this.apiEndpoint;
    }

    public String apiId() {
        return this.apiId;
    }

    public String apiKeySelectionExpression() {
        return this.apiKeySelectionExpression;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public String description() {
        return this.description;
    }

    public Boolean disableSchemaValidation() {
        return this.disableSchemaValidation;
    }

    public String name() {
        return this.name;
    }

    public ProtocolType protocolType() {
        return ProtocolType.fromValue(this.protocolType);
    }

    public String protocolTypeAsString() {
        return this.protocolType;
    }

    public String routeSelectionExpression() {
        return this.routeSelectionExpression;
    }

    public String version() {
        return this.version;
    }

    public List<String> warnings() {
        return this.warnings;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeySelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableSchemaValidation());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.warnings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Api)) {
            return false;
        }
        Api other = (Api)obj;
        return Objects.equals(this.apiEndpoint(), other.apiEndpoint()) && Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.apiKeySelectionExpression(), other.apiKeySelectionExpression()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.disableSchemaValidation(), other.disableSchemaValidation()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.protocolTypeAsString(), other.protocolTypeAsString()) && Objects.equals(this.routeSelectionExpression(), other.routeSelectionExpression()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.warnings(), other.warnings()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"Api").add("ApiEndpoint", (Object)this.apiEndpoint()).add("ApiId", (Object)this.apiId()).add("ApiKeySelectionExpression", (Object)this.apiKeySelectionExpression()).add("CreatedDate", (Object)this.createdDate()).add("Description", (Object)this.description()).add("DisableSchemaValidation", (Object)this.disableSchemaValidation()).add("Name", (Object)this.name()).add("ProtocolType", (Object)this.protocolTypeAsString()).add("RouteSelectionExpression", (Object)this.routeSelectionExpression()).add("Version", (Object)this.version()).add("Warnings", this.warnings()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiEndpoint": {
                return Optional.ofNullable(clazz.cast(this.apiEndpoint()));
            }
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "ApiKeySelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.apiKeySelectionExpression()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisableSchemaValidation": {
                return Optional.ofNullable(clazz.cast(this.disableSchemaValidation()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ProtocolType": {
                return Optional.ofNullable(clazz.cast(this.protocolTypeAsString()));
            }
            case "RouteSelectionExpression": {
                return Optional.ofNullable(clazz.cast(this.routeSelectionExpression()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Api, T> g) {
        return obj -> g.apply((Api)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiEndpoint;
        private String apiId;
        private String apiKeySelectionExpression;
        private Instant createdDate;
        private String description;
        private Boolean disableSchemaValidation;
        private String name;
        private String protocolType;
        private String routeSelectionExpression;
        private String version;
        private List<String> warnings = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Api model) {
            this.apiEndpoint(model.apiEndpoint);
            this.apiId(model.apiId);
            this.apiKeySelectionExpression(model.apiKeySelectionExpression);
            this.createdDate(model.createdDate);
            this.description(model.description);
            this.disableSchemaValidation(model.disableSchemaValidation);
            this.name(model.name);
            this.protocolType(model.protocolType);
            this.routeSelectionExpression(model.routeSelectionExpression);
            this.version(model.version);
            this.warnings(model.warnings);
            this.tags(model.tags);
        }

        public final String getApiEndpoint() {
            return this.apiEndpoint;
        }

        @Override
        public final Builder apiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        public final void setApiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getApiKeySelectionExpression() {
            return this.apiKeySelectionExpression;
        }

        @Override
        public final Builder apiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        public final void setApiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getDisableSchemaValidation() {
            return this.disableSchemaValidation;
        }

        @Override
        public final Builder disableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
            return this;
        }

        public final void setDisableSchemaValidation(Boolean disableSchemaValidation) {
            this.disableSchemaValidation = disableSchemaValidation;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getProtocolTypeAsString() {
            return this.protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        public final Builder protocolType(ProtocolType protocolType) {
            this.protocolType(protocolType.toString());
            return this;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        public final String getRouteSelectionExpression() {
            return this.routeSelectionExpression;
        }

        @Override
        public final Builder routeSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        public final void setRouteSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<String> getWarnings() {
            return this.warnings;
        }

        @Override
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = ___listOf__stringCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(String ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = ___listOf__stringCopier.copy(warnings);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public Api build() {
            return new Api(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Api> {
        public Builder apiEndpoint(String var1);

        public Builder apiId(String var1);

        public Builder apiKeySelectionExpression(String var1);

        public Builder createdDate(Instant var1);

        public Builder description(String var1);

        public Builder disableSchemaValidation(Boolean var1);

        public Builder name(String var1);

        public Builder protocolType(String var1);

        public Builder protocolType(ProtocolType var1);

        public Builder routeSelectionExpression(String var1);

        public Builder version(String var1);

        public Builder warnings(Collection<String> var1);

        public Builder warnings(String ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

