/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.DomainNameStatus;
import software.amazon.awssdk.services.apigatewayv2.model.EndpointType;
import software.amazon.awssdk.services.apigatewayv2.model.SecurityPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainNameConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainNameConfiguration> {
    private static final SdkField<String> API_GATEWAY_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainNameConfiguration.getter(DomainNameConfiguration::apiGatewayDomainName)).setter(DomainNameConfiguration.setter(Builder::apiGatewayDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiGatewayDomainName").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainNameConfiguration.getter(DomainNameConfiguration::certificateArn)).setter(DomainNameConfiguration.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainNameConfiguration.getter(DomainNameConfiguration::certificateName)).setter(DomainNameConfiguration.setter(Builder::certificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()}).build();
    private static final SdkField<Instant> CERTIFICATE_UPLOAD_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DomainNameConfiguration.getter(DomainNameConfiguration::certificateUploadDate)).setter(DomainNameConfiguration.setter(Builder::certificateUploadDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateUploadDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainNameConfiguration.getter(DomainNameConfiguration::endpointTypeAsString)).setter(DomainNameConfiguration.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointType").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainNameConfiguration.getter(DomainNameConfiguration::hostedZoneId)).setter(DomainNameConfiguration.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneId").build()}).build();
    private static final SdkField<String> SECURITY_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainNameConfiguration.getter(DomainNameConfiguration::securityPolicyAsString)).setter(DomainNameConfiguration.setter(Builder::securityPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityPolicy").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainNameConfiguration.getter(DomainNameConfiguration::domainNameStatusAsString)).setter(DomainNameConfiguration.setter(Builder::domainNameStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameStatus").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainNameConfiguration.getter(DomainNameConfiguration::domainNameStatusMessage)).setter(DomainNameConfiguration.setter(Builder::domainNameStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameStatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_GATEWAY_DOMAIN_NAME_FIELD, CERTIFICATE_ARN_FIELD, CERTIFICATE_NAME_FIELD, CERTIFICATE_UPLOAD_DATE_FIELD, ENDPOINT_TYPE_FIELD, HOSTED_ZONE_ID_FIELD, SECURITY_POLICY_FIELD, DOMAIN_NAME_STATUS_FIELD, DOMAIN_NAME_STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String apiGatewayDomainName;
    private final String certificateArn;
    private final String certificateName;
    private final Instant certificateUploadDate;
    private final String endpointType;
    private final String hostedZoneId;
    private final String securityPolicy;
    private final String domainNameStatus;
    private final String domainNameStatusMessage;

    private DomainNameConfiguration(BuilderImpl builder) {
        this.apiGatewayDomainName = builder.apiGatewayDomainName;
        this.certificateArn = builder.certificateArn;
        this.certificateName = builder.certificateName;
        this.certificateUploadDate = builder.certificateUploadDate;
        this.endpointType = builder.endpointType;
        this.hostedZoneId = builder.hostedZoneId;
        this.securityPolicy = builder.securityPolicy;
        this.domainNameStatus = builder.domainNameStatus;
        this.domainNameStatusMessage = builder.domainNameStatusMessage;
    }

    public String apiGatewayDomainName() {
        return this.apiGatewayDomainName;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String certificateName() {
        return this.certificateName;
    }

    public Instant certificateUploadDate() {
        return this.certificateUploadDate;
    }

    public EndpointType endpointType() {
        return EndpointType.fromValue(this.endpointType);
    }

    public String endpointTypeAsString() {
        return this.endpointType;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public SecurityPolicy securityPolicy() {
        return SecurityPolicy.fromValue(this.securityPolicy);
    }

    public String securityPolicyAsString() {
        return this.securityPolicy;
    }

    public DomainNameStatus domainNameStatus() {
        return DomainNameStatus.fromValue(this.domainNameStatus);
    }

    public String domainNameStatusAsString() {
        return this.domainNameStatus;
    }

    public String domainNameStatusMessage() {
        return this.domainNameStatusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiGatewayDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateUploadDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNameStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNameStatusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainNameConfiguration)) {
            return false;
        }
        DomainNameConfiguration other = (DomainNameConfiguration)obj;
        return Objects.equals(this.apiGatewayDomainName(), other.apiGatewayDomainName()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateName(), other.certificateName()) && Objects.equals(this.certificateUploadDate(), other.certificateUploadDate()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.securityPolicyAsString(), other.securityPolicyAsString()) && Objects.equals(this.domainNameStatusAsString(), other.domainNameStatusAsString()) && Objects.equals(this.domainNameStatusMessage(), other.domainNameStatusMessage());
    }

    public String toString() {
        return ToString.builder((String)"DomainNameConfiguration").add("ApiGatewayDomainName", (Object)this.apiGatewayDomainName()).add("CertificateArn", (Object)this.certificateArn()).add("CertificateName", (Object)this.certificateName()).add("CertificateUploadDate", (Object)this.certificateUploadDate()).add("EndpointType", (Object)this.endpointTypeAsString()).add("HostedZoneId", (Object)this.hostedZoneId()).add("SecurityPolicy", (Object)this.securityPolicyAsString()).add("DomainNameStatus", (Object)this.domainNameStatusAsString()).add("DomainNameStatusMessage", (Object)this.domainNameStatusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiGatewayDomainName": {
                return Optional.ofNullable(clazz.cast(this.apiGatewayDomainName()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "CertificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
            case "CertificateUploadDate": {
                return Optional.ofNullable(clazz.cast(this.certificateUploadDate()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "SecurityPolicy": {
                return Optional.ofNullable(clazz.cast(this.securityPolicyAsString()));
            }
            case "DomainNameStatus": {
                return Optional.ofNullable(clazz.cast(this.domainNameStatusAsString()));
            }
            case "DomainNameStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.domainNameStatusMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainNameConfiguration, T> g) {
        return obj -> g.apply((DomainNameConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiGatewayDomainName;
        private String certificateArn;
        private String certificateName;
        private Instant certificateUploadDate;
        private String endpointType;
        private String hostedZoneId;
        private String securityPolicy;
        private String domainNameStatus;
        private String domainNameStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainNameConfiguration model) {
            this.apiGatewayDomainName(model.apiGatewayDomainName);
            this.certificateArn(model.certificateArn);
            this.certificateName(model.certificateName);
            this.certificateUploadDate(model.certificateUploadDate);
            this.endpointType(model.endpointType);
            this.hostedZoneId(model.hostedZoneId);
            this.securityPolicy(model.securityPolicy);
            this.domainNameStatus(model.domainNameStatus);
            this.domainNameStatusMessage(model.domainNameStatusMessage);
        }

        public final String getApiGatewayDomainName() {
            return this.apiGatewayDomainName;
        }

        @Override
        public final Builder apiGatewayDomainName(String apiGatewayDomainName) {
            this.apiGatewayDomainName = apiGatewayDomainName;
            return this;
        }

        public final void setApiGatewayDomainName(String apiGatewayDomainName) {
            this.apiGatewayDomainName = apiGatewayDomainName;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final Instant getCertificateUploadDate() {
            return this.certificateUploadDate;
        }

        @Override
        public final Builder certificateUploadDate(Instant certificateUploadDate) {
            this.certificateUploadDate = certificateUploadDate;
            return this;
        }

        public final void setCertificateUploadDate(Instant certificateUploadDate) {
            this.certificateUploadDate = certificateUploadDate;
        }

        public final String getEndpointTypeAsString() {
            return this.endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getSecurityPolicyAsString() {
            return this.securityPolicy;
        }

        @Override
        public final Builder securityPolicy(String securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        @Override
        public final Builder securityPolicy(SecurityPolicy securityPolicy) {
            this.securityPolicy(securityPolicy == null ? null : securityPolicy.toString());
            return this;
        }

        public final void setSecurityPolicy(String securityPolicy) {
            this.securityPolicy = securityPolicy;
        }

        public final String getDomainNameStatusAsString() {
            return this.domainNameStatus;
        }

        @Override
        public final Builder domainNameStatus(String domainNameStatus) {
            this.domainNameStatus = domainNameStatus;
            return this;
        }

        @Override
        public final Builder domainNameStatus(DomainNameStatus domainNameStatus) {
            this.domainNameStatus(domainNameStatus == null ? null : domainNameStatus.toString());
            return this;
        }

        public final void setDomainNameStatus(String domainNameStatus) {
            this.domainNameStatus = domainNameStatus;
        }

        public final String getDomainNameStatusMessage() {
            return this.domainNameStatusMessage;
        }

        @Override
        public final Builder domainNameStatusMessage(String domainNameStatusMessage) {
            this.domainNameStatusMessage = domainNameStatusMessage;
            return this;
        }

        public final void setDomainNameStatusMessage(String domainNameStatusMessage) {
            this.domainNameStatusMessage = domainNameStatusMessage;
        }

        public DomainNameConfiguration build() {
            return new DomainNameConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainNameConfiguration> {
        public Builder apiGatewayDomainName(String var1);

        public Builder certificateArn(String var1);

        public Builder certificateName(String var1);

        public Builder certificateUploadDate(Instant var1);

        public Builder endpointType(String var1);

        public Builder endpointType(EndpointType var1);

        public Builder hostedZoneId(String var1);

        public Builder securityPolicy(String var1);

        public Builder securityPolicy(SecurityPolicy var1);

        public Builder domainNameStatus(String var1);

        public Builder domainNameStatus(DomainNameStatus var1);

        public Builder domainNameStatusMessage(String var1);
    }
}

